# Unity Cinemachine Skill

## Overview

The Unity Cinemachine skill enables procedural camera systems with virtual cameras, blending, and cinematic control.

## Purpose

Cinemachine handles complex camera logic. This skill provides:

- **Virtual Cameras**: State-based camera switching
- **Procedural Control**: Follow, orbit, shake
- **Cinematic Tools**: Timeline integration
- **Composition**: Framing and screen placement

## Use Cases

1. **Third-Person Cameras**: Follow and orbit
2. **Cutscenes**: Scripted camera sequences
3. **Combat Cameras**: Lock-on and targeting
4. **Cinematics**: Film-like camera work

## Processes That Use This Skill

- **Cutscene Implementation** (`cutscene-implementation.js`)
- **Core Mechanics Prototyping** (`core-mechanics-prototyping.js`)

## Related Skills

- `unity-development`: Core Unity development
- `unity-animation`: Timeline integration
