# Unity ECS Skill

## Overview

The Unity ECS skill enables development using Unity's Data-Oriented Technology Stack (DOTS) for high-performance gameplay systems.

## Purpose

ECS provides massive performance gains for games with many entities. This skill enables:

- **Data-Oriented Design**: Cache-friendly component layouts
- **Jobs System**: Multi-threaded processing
- **Burst Compilation**: Native code performance
- **Scalability**: Handle thousands of entities efficiently

## Use Cases

1. **Large-Scale Simulations**: Thousands of AI agents
2. **Physics-Heavy Games**: Complex physics interactions
3. **Procedural Generation**: Real-time world generation
4. **Performance-Critical Systems**: Any CPU-bound system

## Processes That Use This Skill

- **Performance Optimization** (`performance-optimization.js`)
- **Gameplay Systems** (`gameplay-systems.js`)
- **AI Behavior Implementation** (`ai-behavior-implementation.js`)

## Related Skills

- `unity-development`: Core Unity development
- `physics-engine`: Physics system integration
- `navmesh`: Navigation with ECS
