# Unity HDRP Skill

## Overview

The Unity HDRP skill provides integration with Unity's High Definition Render Pipeline for creating high-fidelity graphics with ray tracing and advanced visual effects.

## Purpose

HDRP enables AAA-quality graphics in Unity. This skill provides:

- **Ray Tracing**: Reflections, GI, shadows, and AO
- **Volumetrics**: Fog, clouds, and atmospheric effects
- **Advanced Materials**: SSS, hair, fabric, and decals
- **Physical Lighting**: Accurate light units and area lights

## Use Cases

1. **High-End PC/Console Games**: AAA visual quality
2. **Architectural Visualization**: Photorealistic rendering
3. **Film Production**: Virtual production pipelines
4. **Automotive**: Product visualization

## Processes That Use This Skill

- **VFX Implementation** (`vfx-implementation.js`)
- **Art Asset Pipeline** (`art-asset-pipeline.js`)
- **Performance Optimization** (`performance-optimization.js`)

## Related Skills

- `unity-urp`: Lightweight alternative pipeline
- `raytracing`: General ray tracing concepts
- `global-illumination`: GI techniques
