# Unity Input System Skill

## Overview

The Unity Input System skill provides cross-platform input handling with action maps, device support, and runtime rebinding.

## Purpose

The New Input System offers flexible input handling. This skill enables:

- **Action-Based Input**: Decouple input from code
- **Multi-Device Support**: Gamepad, keyboard, touch, XR
- **Control Schemes**: Support different device configurations
- **Rebinding**: Player-configurable controls

## Use Cases

1. **Cross-Platform Games**: Support all input devices
2. **Local Multiplayer**: Multiple controllers
3. **Accessibility**: Remappable controls
4. **Complex Actions**: Combos, holds, multi-tap

## Processes That Use This Skill

- **Core Mechanics Prototyping** (`core-mechanics-prototyping.js`)
- **UI/UX Implementation** (`uiux-implementation.js`)
- **Platform Certification** (`platform-certification.js`)

## Related Skills

- `unity-development`: Core Unity development
- `touch-controls`: Mobile input patterns
- `accessibility-games`: Accessibility features
