# Unity Netcode Skill

## Overview

The Unity Netcode skill enables multiplayer game development using Unity's official networking solution.

## Purpose

Netcode for GameObjects provides Unity-native networking. This skill enables:

- **State Sync**: NetworkVariable synchronization
- **RPCs**: Server and client remote calls
- **Player Management**: Connection handling
- **Topology**: Client-server architecture

## Use Cases

1. **Co-op Games**: 2-8 player sessions
2. **Competitive Multiplayer**: Authoritative server
3. **MMO Lite**: Smaller scale persistent worlds
4. **Party Games**: Local and online play

## Processes That Use This Skill

- **Multiplayer Networking** (`multiplayer-networking.js`)
- **Gameplay Systems** (`gameplay-systems.js`)

## Related Skills

- `unity-development`: Core Unity development
- `client-server`: Network architecture
- `state-sync`: Synchronization patterns
