# Unity Physics Skill

## Overview

The Unity Physics skill enables physics-based gameplay using Unity's built-in physics systems.

## Purpose

Physics systems power dynamic gameplay. This skill provides:

- **Rigidbody Dynamics**: Force-based movement
- **Collision Detection**: Triggers and contacts
- **Raycasting**: Physics queries
- **Configuration**: Solver and timestep settings

## Use Cases

1. **Character Controllers**: Physics-based movement
2. **Projectiles**: Bullet and thrown objects
3. **Vehicles**: Wheel colliders, suspension
4. **Puzzles**: Physics-based interactions

## Processes That Use This Skill

- **Gameplay Systems** (`gameplay-systems.js`)
- **Core Mechanics Prototyping** (`core-mechanics-prototyping.js`)

## Related Skills

- `unity-development`: Core Unity development
- `character-physics`: Character controllers
- `vehicle-physics`: Vehicle simulation
