# Unity Profiler Skill

## Overview

The Unity Profiler skill enables performance analysis and optimization using Unity's profiling tools.

## Purpose

Profiling is essential for game optimization. This skill provides:

- **CPU Analysis**: Frame timing, bottlenecks
- **GPU Analysis**: Render passes, shaders
- **Memory Analysis**: Allocations, leaks
- **Automation**: Tests and reports

## Use Cases

1. **Performance Optimization**: Identify and fix bottlenecks
2. **Memory Management**: Track and reduce allocations
3. **Regression Testing**: Automated performance tests
4. **Platform Targets**: Meet frame budgets

## Processes That Use This Skill

- **Performance Optimization** (`performance-optimization.js`)
- **QA Testing Strategy** (`qa-testing-strategy.js`)

## Related Skills

- `unity-development`: Core Unity development
- `occlusion-culling`: Render optimization
- `shader-optimization`: Shader performance
