# Unity VFX Graph Skill

## Overview

The Unity VFX Graph skill enables creation of GPU-accelerated particle systems and visual effects.

## Purpose

VFX Graph provides massive particle counts on GPU. This skill enables:

- **GPU Particles**: Millions of particles
- **Procedural Effects**: Noise, SDFs, mesh sampling
- **Visual Authoring**: Node-based effect creation
- **Event Integration**: Script-driven effects

## Use Cases

1. **Explosions**: Large-scale particle effects
2. **Environmental**: Rain, snow, fire, smoke
3. **Magic Effects**: Spell casting, auras
4. **UI Effects**: Screen-space particles

## Processes That Use This Skill

- **VFX Implementation** (`vfx-implementation.js`)
- **Art Asset Pipeline** (`art-asset-pipeline.js`)

## Related Skills

- `particle-systems`: General particle concepts
- `unity-shader-graph`: Shader integration
- `post-processing`: Screen effects
