# Unreal C++ Skill

## Overview

The Unreal C++ skill enables high-performance game development using Unreal's C++ framework.

## Purpose

C++ provides maximum performance and control. This skill enables:

- **Engine Integration**: UCLASS, UPROPERTY, UFUNCTION
- **Memory Management**: Smart pointers, GC
- **Blueprint Exposure**: Designer-friendly interfaces
- **Performance**: Optimized game systems

## Use Cases

1. **Core Systems**: Gameplay framework
2. **Performance Critical**: Physics, AI
3. **Engine Extensions**: Plugins, tools
4. **Blueprint Base Classes**: Designer iteration

## Processes That Use This Skill

- **Gameplay Systems** (`gameplay-systems.js`)
- **Performance Optimization** (`performance-optimization.js`)

## Related Skills

- `unreal-development`: Core Unreal development
- `unreal-blueprint`: Visual scripting
- `unreal-gamesframework`: GAS integration
