# Unreal Materials Skill

## Overview

The Unreal Materials skill enables material creation using Unreal's node-based Material Editor.

## Purpose

Materials define surface appearance. This skill provides:

- **PBR Workflows**: Physical material properties
- **Material Instances**: Efficient variants
- **Material Functions**: Reusable components
- **Advanced Effects**: Custom shading

## Use Cases

1. **Environment Materials**: Terrain, props
2. **Character Materials**: Skin, cloth, armor
3. **Effect Materials**: Energy, magic
4. **Procedural Materials**: Noise-based

## Processes That Use This Skill

- **Art Asset Pipeline** (`art-asset-pipeline.js`)
- **VFX Implementation** (`vfx-implementation.js`)

## Related Skills

- `unreal-development`: Core Unreal development
- `unreal-nanite`: Geometry integration
- `pbr-rendering`: PBR concepts
