# USB Stack Skill

USB device and host stack implementation expertise.

## Purpose

Provides comprehensive USB development support:
- USB descriptor generation
- Device class implementation (CDC, HID, MSC, DFU)
- Stack configuration (TinyUSB, vendor stacks)
- Protocol debugging and analysis
- Composite device support

## Key Features

- Multi-class device support
- Descriptor generation and validation
- DFU bootloader implementation
- USB power delivery configuration
- Protocol analyzer integration

## Integration

Used by processes requiring USB expertise:
- Device driver development
- Bootloader implementation
- Hardware-software interface specification

## Dependencies

- TinyUSB or vendor USB stack
- USB protocol analyzers
- usb-tools (lsusb, usbmon)
