---
name: vocal-direction
description: Create detailed vocal specifications including style, register, techniques, emotional delivery, and influence references for AI music generation
allowed-tools: Read, Write, Edit, WebSearch
id: SK-MAC-007
---

# Vocal Direction

Create comprehensive vocal specifications for AI music generation platforms.

## Overview

This skill provides frameworks for specifying vocal characteristics that AI music generators can interpret. It covers vocal style, register, techniques, emotional qualities, and artist influence references.

## Capabilities

### Vocal Style Definition
- Specify tonal qualities (breathy, raspy, clear, nasal)
- Define texture characteristics
- Note brightness/warmth balance
- Describe unique qualities

### Register Specification
- Identify vocal range requirements
- Specify typical register usage
- Note falsetto/head voice use
- Define chest voice characteristics

### Technique Identification
- List specific techniques (vibrato, runs, growls)
- Note dynamic approaches
- Specify articulation style
- Define phrasing patterns

### Emotional Direction
- Describe emotional quality
- Note vulnerability levels
- Specify intensity patterns
- Define expressiveness type

### Influence Referencing
- Identify vocal influence artists
- Specify what elements to reference
- Balance multiple influences
- Note era-specific vocal styles

## Vocal Reference Database

### Vocal Styles
| Style | Description | Example Artists |
|-------|-------------|-----------------|
| Breathy | Airy, intimate, soft attack | Billie Eilish, Lana Del Rey |
| Raspy | Gritty, textured, worn | Tom Waits, Amy Winehouse |
| Clear | Pure, precise, clean | Adele, Whitney Houston |
| Nasal | Resonant, distinctive | Bob Dylan, Willie Nelson |
| Husky | Deep, warm, smoky | Leonard Cohen, Sade |
| Ethereal | Otherworldly, floating | Enya, Cocteau Twins |
| Powerful | Big, resonant, belting | Celine Dion, Freddie Mercury |

### Vocal Registers
| Register | Range | Characteristics |
|----------|-------|-----------------|
| Bass | E2-E4 | Deep, resonant, grounded |
| Baritone | A2-A4 | Warm, full, versatile |
| Tenor | C3-C5 | Bright, lyrical, high |
| Alto | F3-F5 | Rich, warm, mezzo |
| Mezzo-Soprano | A3-A5 | Versatile, warm |
| Soprano | C4-C6 | High, bright, agile |

### Vocal Techniques
| Technique | Description | Genre Context |
|-----------|-------------|---------------|
| Vibrato | Pitch oscillation | Classical, Soul, Pop |
| Runs/Melisma | Rapid note sequences | R&B, Gospel, Pop |
| Growl | Distorted, aggressive | Metal, Blues, Rock |
| Falsetto | Head voice, airy | Soul, R&B, Pop |
| Belt | Powerful chest voice | Musical Theater, Pop |
| Whisper | Soft, intimate | Indie, Pop, Electronic |
| Yodel | Register flips | Folk, Country |
| Fry | Low, creaky | Pop, Indie |
| Scream | High-intensity shout | Punk, Metal |

### Emotional Qualities
| Quality | Description | Expression |
|---------|-------------|------------|
| Vulnerable | Exposed, fragile | Soft dynamics, breaks |
| Confident | Assured, strong | Full voice, clear |
| Anguished | Pained, desperate | Strained, dynamic |
| Joyful | Happy, uplifting | Bright, energetic |
| Melancholic | Sad, longing | Minor inflections |
| Defiant | Rebellious, strong | Aggressive edge |
| Intimate | Close, personal | Quiet, breathy |
| Passionate | Intense, fervent | Dynamic range |

## Usage Guidelines

### Vocal Specification Format
```markdown
## Vocal Direction

### Style
- **Primary Quality**: [Style descriptor]
- **Texture**: [Smooth/Rough/Warm/Bright]
- **Unique Characteristics**: [Specific qualities]

### Register
- **Range**: [Register name]
- **Primary Zone**: [Where they sit most]
- **Extended Range**: [High/low reaches]

### Techniques
- **Primary**: [Main techniques used]
- **Occasional**: [Sometimes employed]
- **Signature**: [Unique to this artist]

### Emotional Delivery
- **Core Quality**: [Primary emotion]
- **Dynamic Range**: [How much variation]
- **Intensity**: [1-10 baseline]

### Influences
| Artist | What to Reference |
|--------|-------------------|
| [Name] | [Specific quality] |
```

### Quality Checklist
- [ ] Style is clearly defined
- [ ] Register is appropriate for genre
- [ ] Techniques are genre-authentic
- [ ] Emotional direction is specific
- [ ] Influences are relevant and clear

## Integration Points

### Related Skills
- SK-MAC-002 (style-specification) - Vocal in full context
- SK-MAC-004 (persona-development) - Voice as character
- SK-MAC-010 (music-prompt-engineering) - Platform formatting

### Related Agents
- AG-MAC-002 (music-producer-agent) - Vocal production

## References

- Vocal pedagogy resources
- Genre-specific vocal traditions
- AI music platform vocal tags
