---
name: vpd-design
description: Customer-centric value proposition development using jobs-to-be-done methodology
allowed-tools:
  - Read
  - Write
  - Glob
  - Grep
  - WebSearch
  - WebFetch
metadata:
  specialization: business-strategy
  domain: business
  category: Customer Value
  skill-id: SK-007
---

# Value Proposition Design Skill

## Overview

The Value Proposition Design skill enables systematic customer-centric value proposition development using the jobs-to-be-done framework. It facilitates structured analysis of customer profiles and value maps to achieve problem-solution fit and deliver compelling value propositions that address real customer needs.

## Capabilities

### Customer Jobs Identification
- Identify functional jobs customers are trying to accomplish
- Uncover social jobs related to how customers want to be perceived
- Discover emotional jobs and feelings customers seek
- Map supporting jobs in the purchasing and consumption journey
- Analyze job context, frequency, and importance

### Pain Point Mapping
- Identify undesired outcomes and problems customers experience
- Map obstacles preventing job completion
- Assess pain severity and frequency
- Uncover risks and negative consequences feared by customers
- Prioritize pains by intensity and relevance

### Gain Identification
- Identify required gains (expected outcomes)
- Discover expected gains (basic expectations)
- Uncover desired gains (beyond expectations)
- Identify unexpected gains (delight factors)
- Score gains by relevance and importance to customers

### Profile Prioritization
- Segment customer profiles by characteristics
- Prioritize profiles by strategic importance
- Assess profile attractiveness and fit
- Map profile variations across segments
- Identify underserved profiles with high potential

### Product/Service Design
- Design products and services that address customer jobs
- Map features to specific job steps
- Ensure completeness of job coverage
- Evaluate feasibility and desirability
- Create minimal viable propositions

### Pain Reliever Effectiveness
- Design pain relievers for critical pains
- Assess pain reliever intensity and coverage
- Validate pain reliever effectiveness
- Identify pain relief gaps
- Optimize pain reliever portfolio

### Gain Creator Impact
- Design gain creators for important gains
- Evaluate gain creator impact and reach
- Validate gain creator relevance
- Identify gain creation opportunities
- Optimize gain creator effectiveness

### Problem-Solution Fit Scoring
- Assess fit between profile and value map
- Score problem-solution fit quantitatively
- Identify fit gaps and misalignments
- Recommend fit improvements
- Track fit evolution over time

### Value Proposition Statement
- Generate compelling value proposition statements
- Craft customer-specific messaging
- Develop positioning statements
- Create differentiation narratives
- Test statement clarity and impact

### Fit Gap Analysis
- Conduct comprehensive fit gap analysis
- Identify critical missing elements
- Recommend iteration priorities
- Design validation experiments
- Guide continuous improvement

## Process Integration

This skill integrates with the following processes:

- **value-proposition-design.js**: Primary process for all phases of value proposition development
- **business-model-canvas.js**: Integrates with Value Proposition section of the canvas
- **blue-ocean-strategy.js**: Supports value innovation analysis
- **competitive-intelligence.js**: Enables value proposition comparison across competitors

## Usage

### Basic Value Proposition Development
```
Use the vpd-design skill to develop a comprehensive value proposition:
1. Create customer profile with jobs, pains, and gains
2. Design value map with products, pain relievers, and gain creators
3. Assess problem-solution fit
4. Generate value proposition statement
5. Identify iteration recommendations
```

### Customer Profile Analysis
```
Use the vpd-design skill to deeply understand customers:
1. Map all customer jobs (functional, social, emotional)
2. Identify and rank customer pains
3. Discover customer gains and aspirations
4. Prioritize profile elements by importance
5. Segment and prioritize customer profiles
```

### Fit Improvement
```
Use the vpd-design skill to improve problem-solution fit:
1. Score current fit across all dimensions
2. Identify critical gaps
3. Prioritize improvement opportunities
4. Design targeted interventions
5. Validate improvements with customers
```

## Dependencies

- Jobs-to-be-done (JTBD) methodology frameworks
- Customer research synthesis tools
- Value proposition canvas templates
- Fit scoring algorithms
- Customer segment analysis frameworks

## Best Practices

1. **Start with Customer Profile**: Always begin with deep customer understanding before designing value maps
2. **Prioritize Ruthlessly**: Focus on the most important jobs, extreme pains, and essential gains
3. **Validate Assumptions**: Test all assumptions about customer jobs, pains, and gains
4. **Iterate Continuously**: Value propositions evolve - maintain regular fit assessments
5. **Be Specific**: Avoid generic statements - be precise about value delivered

## Output Formats

- Customer Profile Canvas (visual)
- Value Map Canvas (visual)
- Fit Assessment Scorecard
- Value Proposition Statement Document
- Gap Analysis Report
- Iteration Recommendations
