---
name: vulnerability-scanner
description: Security vulnerability scanning for dependencies and code, with CVE database checking and risk assessment
allowed-tools: ["Bash", "Read", "Write", "Grep", "Glob", "Edit"]
---

# Vulnerability Scanner Skill

Performs comprehensive security vulnerability scanning for dependencies and code, integrating with CVE databases and security platforms to identify, assess, and prioritize security risks for migration planning.

## Purpose

Enable comprehensive security vulnerability detection for:
- CVE database checking for known vulnerabilities
- Severity assessment and prioritization
- Exploitability analysis
- Patch availability checking
- Transitive vulnerability chain mapping
- Risk scoring and remediation guidance

## Capabilities

### 1. CVE Database Checking
- Query NVD (National Vulnerability Database)
- Check GitHub Advisory Database
- Query vendor-specific advisory databases
- Cross-reference multiple CVE sources
- Track CVE publication dates and updates

### 2. Severity Assessment
- CVSS (Common Vulnerability Scoring System) scoring
- Severity categorization (Critical, High, Medium, Low)
- Environmental score adjustments
- Temporal score analysis
- Impact assessment

### 3. Exploitability Analysis
- Check for known exploits in the wild
- Assess attack vector complexity
- Evaluate privileges required
- Analyze user interaction requirements
- Track exploit maturity level

### 4. Patch Availability Checking
- Identify available patches and fixes
- Check for security advisories
- Find upgrade paths to secure versions
- Track vendor patch timelines
- Monitor backport availability

### 5. Transitive Vulnerability Chain Mapping
- Map vulnerability paths through dependency trees
- Identify all affected dependency chains
- Calculate exposure scope
- Prioritize based on path depth
- Recommend targeted remediations

### 6. Risk Scoring
- Calculate composite risk scores
- Factor in business context
- Assess exposure likelihood
- Evaluate potential impact
- Generate prioritized remediation lists

## Tool Integrations

This skill can leverage the following external tools when available:

| Tool | Purpose | Integration Method |
|------|---------|-------------------|
| Snyk | Comprehensive vulnerability scanning | CLI / API |
| npm audit | Node.js vulnerability scanning | CLI |
| OWASP Dependency-Check | Cross-platform scanning | CLI |
| Trivy | Container and filesystem scanning | MCP Server / CLI |
| Grype | Vulnerability scanner | CLI |
| GitHub Dependabot | Advisory checking | API |
| OSV Scanner | Google's vulnerability scanner | CLI |
| Semgrep | SAST with security rules | CLI |
| MCP-Scan | MCP server security | Tool |

## Usage

### Basic Scanning

```bash
# Invoke skill for vulnerability scanning
# The skill will scan dependencies and optionally code

# Expected inputs:
# - targetPath: Path to project root
# - scanScope: 'dependencies' | 'code' | 'full'
# - severityThreshold: 'critical' | 'high' | 'medium' | 'low'
# - outputFormat: 'json' | 'sarif' | 'markdown'
```

### Scanning Workflow

1. **Discovery Phase**
   - Identify package managers and dependency files
   - Detect codebase languages
   - Check for existing security configurations

2. **Dependency Scanning**
   - Extract dependency information
   - Query vulnerability databases
   - Map vulnerabilities to dependencies

3. **Code Scanning (Optional)**
   - Run SAST analysis
   - Check for security anti-patterns
   - Identify hardcoded secrets

4. **Analysis Phase**
   - Calculate severity scores
   - Assess exploitability
   - Check patch availability
   - Map transitive chains

5. **Report Generation**
   - Generate prioritized vulnerability list
   - Provide remediation guidance
   - Create compliance reports

## Output Schema

```json
{
  "scanId": "string",
  "timestamp": "ISO8601",
  "target": {
    "path": "string",
    "packageManagers": ["string"],
    "languages": ["string"]
  },
  "summary": {
    "totalVulnerabilities": "number",
    "critical": "number",
    "high": "number",
    "medium": "number",
    "low": "number",
    "fixable": "number",
    "riskScore": "number (0-100)"
  },
  "vulnerabilities": [
    {
      "id": "string (CVE-XXXX-XXXXX)",
      "title": "string",
      "description": "string",
      "severity": "critical|high|medium|low",
      "cvss": {
        "score": "number",
        "vector": "string",
        "version": "string"
      },
      "package": {
        "name": "string",
        "version": "string",
        "ecosystem": "string"
      },
      "affectedVersions": "string",
      "fixedVersions": "string",
      "patchAvailable": "boolean",
      "exploitability": {
        "hasKnownExploit": "boolean",
        "exploitMaturity": "string",
        "attackVector": "string"
      },
      "dependencyPath": ["string"],
      "references": ["string"],
      "remediation": {
        "recommendation": "string",
        "upgradeTarget": "string",
        "alternativePackages": ["string"]
      }
    }
  ],
  "securityIssues": [
    {
      "type": "string",
      "severity": "string",
      "file": "string",
      "line": "number",
      "description": "string",
      "cwe": "string",
      "recommendation": "string"
    }
  ],
  "compliance": {
    "passesPolicy": "boolean",
    "violations": ["string"],
    "waivers": ["string"]
  }
}
```

## Integration with Migration Processes

This skill integrates with the following Code Migration/Modernization processes:

- **dependency-analysis-updates**: Security assessment of dependencies
- **security-remediation-migration**: Primary tool for security fixes
- **cloud-migration**: Security compliance for cloud deployment
- **legacy-codebase-assessment**: Security posture evaluation

## Configuration

### Skill Configuration File

Create `.vulnerability-scanner.json` in the project root:

```json
{
  "scanScope": "full",
  "severityThreshold": "medium",
  "failOnSeverity": "critical",
  "databases": ["nvd", "ghsa", "osv"],
  "excludeVulnerabilities": [],
  "waivers": [
    {
      "id": "CVE-2021-12345",
      "reason": "Not exploitable in our context",
      "expiresAt": "2026-06-01"
    }
  ],
  "policy": {
    "maxCritical": 0,
    "maxHigh": 5,
    "requirePatchWithin": {
      "critical": "7d",
      "high": "30d",
      "medium": "90d"
    }
  },
  "reporting": {
    "formats": ["json", "sarif", "markdown"],
    "outputDir": "./security-report"
  }
}
```

## MCP Server Integration

When MCP-Scan is available:

```javascript
// Example MCP security scan
{
  "tool": "mcp_scan_security",
  "arguments": {
    "target": "./",
    "checks": ["toolPoisoning", "piiDetection", "promptInjection"]
  }
}
```

When Trivy is available:

```javascript
// Example Trivy vulnerability scan
{
  "tool": "trivy_scan",
  "arguments": {
    "target": "./",
    "scanners": ["vuln", "secret"],
    "severity": "CRITICAL,HIGH"
  }
}
```

## Vulnerability Databases

### Supported Databases

| Database | Coverage | Update Frequency |
|----------|----------|------------------|
| NVD | All CVEs | Hourly |
| GitHub Advisory | Open source packages | Real-time |
| OSV | Multi-ecosystem | Real-time |
| Snyk DB | Proprietary enrichment | Real-time |
| npm Advisory | Node.js packages | Real-time |
| RustSec | Rust packages | Real-time |

### Database Priority

1. GitHub Advisory Database (most accurate for open source)
2. NVD (comprehensive, standardized)
3. OSV (aggregated, multi-ecosystem)
4. Vendor-specific (ecosystem-specific details)

## Severity Classification

### CVSS v3.x Mapping

| CVSS Score | Severity | Action Required |
|------------|----------|-----------------|
| 9.0 - 10.0 | Critical | Immediate remediation |
| 7.0 - 8.9 | High | Priority remediation |
| 4.0 - 6.9 | Medium | Scheduled remediation |
| 0.1 - 3.9 | Low | Monitor and plan |

### Risk Prioritization Factors

1. **Severity Score**: Base CVSS score
2. **Exploitability**: Known exploits in the wild
3. **Exposure**: Internet-facing vs internal
4. **Dependency Depth**: Direct vs transitive
5. **Fix Availability**: Patch/upgrade available

## Best Practices

1. **Regular Scanning**: Integrate into CI/CD pipelines
2. **Policy Enforcement**: Define and enforce security policies
3. **Waiver Management**: Document and review waivers regularly
4. **Prioritization**: Focus on critical and exploitable vulnerabilities
5. **Monitoring**: Set up alerts for new vulnerabilities
6. **Remediation Tracking**: Track remediation progress over time

## Related Skills

- `dependency-scanner`: Dependency inventory and SBOM generation
- `static-code-analyzer`: Code-level security analysis
- `compliance-validator`: Compliance checking

## Related Agents

- `security-vulnerability-assessor`: Uses this skill for security assessment
- `dependency-modernization-agent`: Uses this skill for security updates
- `migration-readiness-assessor`: Uses this skill for security evaluation

## References

- [MCP-Scan](https://github.com/invariantlabs-ai/mcp-scan)
- [Trivy](https://aquasecurity.github.io/trivy/)
- [Snyk](https://snyk.io/)
- [OWASP Dependency-Check](https://owasp.org/www-project-dependency-check/)
- [OSV Scanner](https://google.github.io/osv-scanner/)
- [NVD](https://nvd.nist.gov/)
- [GitHub Advisory Database](https://github.com/advisories)
