# wandb-experiment-tracker

Weights & Biases integration skill for experiment tracking, hyperparameter sweeps, and artifact versioning.

## Purpose

This skill provides comprehensive experiment tracking and collaboration capabilities using Weights & Biases, enabling teams to log, visualize, and share ML experiments effectively.

## Key Features

- **Experiment Tracking**: Log metrics, hyperparameters, and metadata
- **Sweeps**: Automated hyperparameter optimization
- **Artifacts**: Version and track datasets, models, and results
- **Visualizations**: Interactive dashboards and custom plots
- **Collaboration**: Share experiments and generate reports

## When to Use

- Tracking ML experiments with rich visualizations
- Running hyperparameter sweeps
- Collaborating with team members on experiments
- Generating reports for stakeholders
- Managing model and dataset versions

## Integration

Works seamlessly with:
- `pytorch-trainer` for PyTorch experiments
- `tensorflow-trainer` for TensorFlow experiments
- `optuna-hyperparameter-tuner` for hyperparameter optimization
- `mlflow-experiment-tracker` for cross-platform tracking
