---
name: world-building
id: SK-FTV-008
version: 1.0.0
description: Design settings, locations, props, costumes, and production elements for film/TV with visual consistency
specialization: film-tv-production
---

# World Building Skill

## Purpose

Create immersive, consistent worlds that support storytelling through production design. Every visual element—locations, props, costumes—should reinforce theme, character, and narrative while maintaining internal consistency.

## World Parameters

### Establishing the Rules

| Parameter | Questions to Define |
|-----------|---------------------|
| Time Period | When does this take place? |
| Geography | Where in the world? |
| Technology | What's possible? |
| Society | How is it organized? |
| Economy | How do people live? |
| Culture | What do people believe? |
| Rules | What's possible/impossible? |

### World Building Layers

```
MACRO WORLD
├── Geography (continents, nations, cities)
├── History (what came before)
├── Politics (power structures)
├── Economy (how things work)
└── Culture (beliefs, customs)

MICRO WORLD
├── Neighborhoods (local areas)
├── Buildings (structures characters use)
├── Interiors (rooms and spaces)
├── Props (objects characters touch)
└── Details (texture and specificity)
```

## Location Design

### Location Profile Template

```markdown
## [LOCATION NAME]

### Basic Info
- **Type:** INT/EXT
- **Category:** [Home, workplace, public, etc.]
- **Story Function:** [What happens here]
- **Scenes:** [Scene numbers]

### Physical Description
- **Size/Scale:**
- **Architecture:**
- **Layout:**
- **Key Features:**
- **Entry/Exit Points:**

### Atmosphere
- **Lighting:**
- **Color Palette:**
- **Textures:**
- **Sound Environment:**
- **Mood:**

### Production Notes
- **Set vs. Location:**
- **Special Requirements:**
- **VFX Needs:**
- **Time Variations:**

### AI Image Prompt
[Detailed prompt for visualization]
```

### Location Types

| Type | Considerations |
|------|----------------|
| Public Spaces | Crowds, geography, time of day |
| Domestic | Character expression, lived-in feel |
| Workplace | Function, hierarchy, activity |
| Transit | Movement, transition, anonymity |
| Nature | Weather, scale, accessibility |

## Production Design Elements

### Props

**Hero Props** (story-critical):
```markdown
- Name and description
- Story significance
- Detailed specifications
- Handling characters
- Visual prompts
```

**Action Props** (character-used):
```markdown
- Category (weapon, tool, device)
- Function
- Period accuracy
- Scene appearances
```

**Set Dressing** (environmental):
```markdown
- Location-specific lists
- Period/style appropriate
- Storytelling elements
- Background texture
```

### Costume Design

**Character Wardrobe Approach:**
```markdown
## [CHARACTER] Costume Concept

### Overall Direction
- Style influences
- Color palette
- Silhouette
- Character expression

### Signature Look
- Key pieces
- Accessories
- Styling notes
- Visual prompt

### Wardrobe Arc
- How costume evolves
- Key changes
- Story meaning
```

### Color Palette

**World Color Strategy:**
```
Primary:   [Dominant colors]
Secondary: [Accent colors]
Accent:    [Highlight/contrast]
Avoid:     [Colors to exclude]

Character Color Coding:
- Protagonist: [Colors]
- Antagonist:  [Colors]
- Support:     [Colors]
```

## Visual Consistency

### Style Guide Elements

```markdown
## Visual Style Guide

### Overall Aesthetic
[Description of visual approach]

### Architecture
- Period: [Historical reference]
- Style: [Modern, Victorian, Art Deco, etc.]
- Materials: [Wood, steel, concrete, etc.]

### Texture Palette
- Surfaces: [Rough, smooth, worn, etc.]
- Materials: [Fabric, metal, glass, etc.]
- Wear level: [Pristine, lived-in, decayed]

### Color Temperature
- Warm/Cool bias
- Saturation level
- Contrast approach

### Visual References
- Films: [Reference movies]
- Art: [Artists, periods]
- Photography: [Styles, photographers]
```

## Environment Categories

### Urban
```
Street level, building facades, interiors,
public transit, parks, nightlife, commercial
```

### Suburban
```
Residential, yards, schools, strip malls,
community spaces, domestic interiors
```

### Rural
```
Open land, farms, small towns, nature,
isolation, simplicity, work spaces
```

### Fantasy/Sci-Fi
```
Imagined architecture, impossible spaces,
future/past technology, altered physics
```

## VFX Planning

### VFX Categories

| Type | Examples |
|------|----------|
| Invisible | Wire removal, set extension |
| Environment | CG locations, weather |
| Creature | Digital characters, animals |
| Action | Explosions, destruction |
| Enhancement | Color, atmosphere |

### VFX Shot Template

```markdown
## VFX Shot [ID]

- **Scene:** [Number]
- **Description:** [What's the effect]
- **Category:** [Invisible/Environment/Creature/Action]
- **Complexity:** [Simple/Moderate/Complex/Hero]
- **Approach:** [How to achieve]
- **Plate Requirements:** [What to shoot]
- **AI Video Prompt:** [For generation]
```

## World Bible Structure

```markdown
# [PROJECT] World Bible

## Overview
- Time period
- Geographic scope
- World rules

## Visual Approach
- Color palette
- Texture palette
- Style references

## Locations
### [Location 1]
[Full profile]

## Production Design
### Props
[Master list]

### Costumes
[Character wardrobe guides]

## VFX Requirements
[Breakdown]

## Reference Gallery
[Image prompts and descriptions]
```

## Quality Checklist

- [ ] World rules are consistent
- [ ] Locations serve story
- [ ] Props are period-appropriate
- [ ] Costumes express character
- [ ] Color palette is cohesive
- [ ] VFX are identified
- [ ] Production is feasible
- [ ] Visual references clear
