---
name: zotero-reference-manager
description: Reference management for bibliography organization, annotation sync, and citation formatting
allowed-tools:
  - Bash
  - Read
  - Write
  - Edit
  - Glob
  - Grep
metadata:
  specialization: scientific-discovery
  domain: science
  category: literature-knowledge
  phase: 6
---

# Zotero Reference Manager

## Purpose

Provides reference management capabilities for bibliography organization, annotation synchronization, and citation formatting.

## Capabilities

- Reference import from multiple sources
- Annotation and note management
- Citation style formatting (CSL)
- Group library collaboration
- PDF attachment management
- BibTeX/RIS export

## Usage Guidelines

1. **Organization**: Use collections and tags for organization
2. **Annotation**: Sync highlights and notes with references
3. **Citation Styles**: Apply appropriate CSL styles
4. **Collaboration**: Share libraries with research groups

## Tools/Libraries

- Pyzotero
- Zotero API
