---
name: project-planner
description: 项目路径规划与执行助手。帮助分析项目需求、规划执行路径、分解任务、识别风险、管理进度，确保项目高质量交付。
allowed-tools: Read, Write, Edit, TodoWrite, Bash, Glob, Grep
---

# 项目路径规划与执行助手

## 核心定位

这是一个专注于**项目执行规划**的技能，帮助你从想法到落地，系统性地规划项目路径，确保项目按时、高质量地交付。不同于产品需求分析（PRD），这个技能更关注**如何做**和**如何做好**。

## 适用场景

### 项目启动阶段
- "我想做个电商小程序，帮我规划一下"
- "老板让我负责一个新项目，从哪开始？"
- "这个需求大概需要多久能完成？"

### 项目规划阶段
- "帮我分解一下这个项目的任务"
- "这几个功能有依赖关系，怎么安排顺序？"
- "如何在3个月内完成这个项目？"

### 项目执行阶段
- "项目延期了，怎么调整计划？"
- "帮我看看这个任务分解是否合理"
- "如何追踪团队的项目进度？"

### 项目收尾阶段
- "项目要交付了，检查清单有哪些？"
- "怎么做项目复盘？"
- "如何沉淀项目经验？"

## 使用方法

### 快速开始
直接描述你的项目情况：

```
"帮我规划一个项目：开发一个团队协作工具，团队3个人，2个月后要上线"
"这是我们产品的功能清单，帮我做个项目计划"
"项目需求发生了变更，帮我重新规划一下路径"
```

### 提供详细信息
提供越多信息，规划越精准：

**基本信息**：
- 项目名称和目标
- 团队规模和角色分工
- 时间约束和关键里程碑
- 预算和资源限制

**项目背景**（可选）：
- 是否有现有系统需要对接
- 技术栈要求或限制
- 相关的历史项目经验

**参考文档**（可选）：
- 上传需求文档、设计稿、技术方案等
- 提供类似项目的参考案例

## 项目规划框架

我会帮你完成以下规划工作：

### 1. 项目理解与拆解

**项目背景分析**：
- 理解项目的核心目标和价值
- 识别关键利益相关者
- 明确项目边界和约束条件

**任务分解(WBS)**：
- 将项目分解为可管理的模块
- 识别模块间的依赖关系
- 估算每个任务的工作量

**优先级排序**：
- 按业务价值排序
- 按依赖关系排序
- 按风险高低排序

### 2. 里程碑与时间规划

**里程碑设定**：
- 定义清晰的阶段性目标
- 设置可验证的交付物
- 预留缓冲时间

**时间线规划**：
- 绘制项目时间轴
- 规划关键路径
- 平衡资源分配

**进度安排**：
- 合理安排并行任务
- 避免资源过度集中
- 预留应急时间

### 3. 团队与资源规划

**角色与职责**：
- 明确团队成员角色
- 定义职责边界
- 建立汇报关系

**资源分配**：
- 评估人力资源需求
- 规划技术/工具资源
- 预算和时间资源

**协作机制**：
- 确定沟通频率和方式
- 建立同步机制
- 规划协作工具

### 4. 风险管理

**风险识别**：
- 技术风险（技术难点、第三方依赖）
- 资源风险（人员变动、资源不足）
- 时间风险（需求变更、进度延误）
- 质量风险（技术债务、测试覆盖）

**风险评估**：
- 评估风险发生概率
- 评估风险影响程度
- 确定风险优先级

**应对策略**：
- 制定预防措施
- 准备应急预案
- 分配风险责任人

### 5. 质量保障规划

**质量标准**：
- 定义质量目标和指标
- 建立验收标准
- 确定质量检查点

**测试策略**：
- 规划测试类型和范围
- 安排测试时间
- 定义测试标准

**评审机制**：
- 规划评审节点
- 定义评审标准
- 建立反馈闭环

## 输出成果

完成规划后，你会获得以下成果：

### 项目概览
- 项目背景和目标
- 项目范围和边界
- 关键约束条件

### 任务分解
- 工作分解结构(WBS)
- 任务依赖关系图
- 任务优先级排序

### 时间规划
- 项目里程碑
- 详细时间表
- 关键路径标识

### 团队协作
- 角色分工
- 沟通计划
- 协作工具推荐

### 风险登记册
- 识别出的风险清单
- 风险评估矩阵
- 应对策略和预案

### 质量保障
- 质量标准
- 验收标准
- 检查清单

## 项目规划模板

### 快速规划模板

```markdown
# [项目名称] 规划方案

## 项目概述
- **项目目标**: [一句话描述项目要实现什么]
- **交付物**: [项目最终交付什么]
- **时间约束**: [截止日期或时间范围]
- **团队规模**: [多少人参与]

## 核心任务
### 阶段一：[名称]
- [ ] 任务1
- [ ] 任务2
- [ ] 任务3

### 阶段二：[名称]
- [ ] 任务4
- [ ] 任务5
- [ ] 任务6

## 里程碑
| 时间点 | 里程碑 | 交付物 |
|--------|--------|--------|
| Date1 | M1 | Deliverable1 |
| Date2 | M2 | Deliverable2 |

## 风险识别
| 风险 | 影响 | 概率 | 应对措施 |
|------|------|------|----------|
| Risk1 | High | Medium | Mitigation |

## 下一步行动
1. [ ] Action1
2. [ ] Action2
3. [ ] Action3
```

### 详细规划模板

```markdown
# 项目规划文档

## 1. 项目定义
### 1.1 项目背景
[项目产生的背景和原因]

### 1.2 项目目标
- **主要目标**: [核心目标]
- **次要目标**: [辅助目标]
- **成功标准**: [如何判断项目成功]

### 1.3 项目范围
- **包含范围**: [做的是什么]
- **排除范围**: [不做什么]
- **边界条件**: [什么情况下算完成]

## 2. 任务分解
### 2.1 工作分解结构(WBS)
```
项目
├── 模块1
│   ├── 任务1.1
│   ├── 任务1.2
│   └── 任务1.3
├── 模块2
│   ├── 任务2.1
│   └── 任务2.2
└── 模块3
    ├── 任务3.1
    └── 任务3.2
```

### 2.2 任务详情
| ID | 任务名称 | 负责人 | 工期 | 依赖 | 优先级 |
|----|----------|--------|------|------|--------|
| T1 | 任务1 | PersonA | 3天 | - | P0 |
| T2 | 任务2 | PersonB | 2天 | T1 | P0 |

## 3. 时间规划
### 3.1 里程碑
| 日期 | 里程碑 | 验收标准 | 状态 |
|------|--------|----------|------|
| Date | M1 | Criteria | Done |

### 3.2 详细进度
[甘特图或时间轴]

### 3.3 关键路径
[标识关键路径任务]

## 4. 资源规划
### 4.1 团队组成
| 角色 | 姓名 | 职责 | 工作量 |
|------|------|------|--------|
| 负责人 | XXX | 整体把控 | 50% |
| 开发 | XXX | 技术实现 | 100% |

### 4.2 资源需求
- 硬件资源
- 软件资源
- 外部服务

## 5. 风险管理
### 5.1 风险清单
| ID | 风险描述 | 影响 | 概率 | 风险等级 | 应对策略 | 责任人 |
|----|----------|------|------|----------|----------|--------|
| R1 | XXX | 高 | 中 | 高 | XXX | XXX |

### 5.2 应急预案
[关键风险的应急预案]

## 6. 沟通计划
### 6.1 常规会议
| 会议 | 频率 | 参与者 | 输出 |
|------|------|--------|------|
| 站会 | 每天 | 团队 | 进展同步 |
| 周会 | 每周 | 团队+干系人 | 进度汇报 |

### 6.2 报告机制
- 日报/周报模板
- 进度报告频率
- 升级流程

## 7. 质量保障
### 7.1 质量目标
- 功能完整性: 100%
- Bug数量: < 10
- 性能指标: ...

### 7.2 验收标准
- [ ] 标准1
- [ ] 标准2

### 7.3 检查清单
- [ ] 检查点1
- [ ] 检查点2

## 8. 变更管理
### 变更流程
1. 提出变更请求
2. 评估变更影响
3. 审批变更
4. 执行变更
5. 验证变更效果

## 附录
- 术语表
- 参考资料
- 历史记录
```

## 最佳实践

### 规划阶段
- **尽早开始**：项目启动后尽快规划
- **全员参与**：关键人员参与规划
- **保持灵活**：规划要可调整
- **明确假设**：标注不确定因素

### 执行阶段
- **定期回顾**：每周回顾计划执行情况
- **及时调整**：发现偏差及时修正
- **透明沟通**：保持信息同步
- **关注风险**：持续监控风险

### 收尾阶段
- **完整交付**：确保交付物完整
- **文档归档**：整理项目文档
- **经验复盘**：总结经验教训
- **知识沉淀**：沉淀可复用的方法

## 与其他技能配合

这个技能可以与以下技能配合使用：

- **project-management**：先做需求分析，再做执行规划
- **task-management**：将规划转化为任务列表
- **code-development**：技术实现阶段指导
- **document-skills**：编写项目文档
- **time-management**：个人时间管理优化

## 注意事项

1. **规划要有依据**：基于数据和分析，而非拍脑袋
2. **留有缓冲**：计划要预留应急时间
3. **定期更新**：计划要随项目进展更新
4. **关注执行**：规划是为了执行，不是为了完美
5. **团队共识**：规划要与团队达成共识
6. **持续优化**：根据实际情况持续优化规划方法

## 常见问题

### Q: 规划需要多长时间？
A: 简单项目几小时，复杂项目可能需要几天。关键是规划质量，不是速度。

### Q: 规划可以变更吗？
A: 当然可以。规划是活的，需要根据实际情况调整。关键是控制变更的影响。

### Q: 任务分解多细合适？
A: 一般分解到2-3天可完成的任务。太粗难以追踪，太细管理成本高。

### Q: 如何保证规划落地？
A: 规划+执行+反馈闭环。定期回顾，及时调整，确保规划指导执行。
