---
name: backend-development-nodejs
description: "Node.js后端开发专家。精通NestJS、Express、Koa等框架，以及TypeScript、Prisma、Redis等技术栈。"
license: MIT
metadata:
  version: 1.0.0
  domains: [backend, nodejs, typescript, nestjs, express, api, database]
  type: specialist
---

# Node.js 后端开发专家

## 当使用此技能

- 企业级应用 (NestJS)
- 快速 API 开发 (Express/Koa)
- 实时通信 (Socket.io)
- GraphQL (Apollo/TypeGraphQL)
- 数据库 ORM (Prisma/TypeORM)

## 框架选择

| 框架 | 适用场景 |
|------|----------|
| **NestJS** | 企业应用、微服务、GraphQL |
| **Express** | 快速 API、RESTful 服务 |
| **Koa** | 轻量级、中间件优先 |

## 技术栈

- **语言**: TypeScript
- **ORM**: Prisma, TypeORM
- **缓存**: Redis
- **实时**: Socket.io
- **GraphQL**: Apollo, TypeGraphQL

## 最佳实践

1. **类型安全**: 全程 TypeScript
2. **依赖注入**: NestJS DI 模式
3. **异步处理**: async/await
4. **错误处理**: 统一异常过滤器
5. **验证**: class-validator
6. **测试**: Jest + Supertest

## 触发词

- "Node.js 后端"
- "NestJS 项目"
- "Express API"
- "TypeScript 服务"
- "Prisma ORM"
