---
name: backend-development-python
description: "Python后端开发专家。精通FastAPI、Django、Flask等框架，以及Pydantic、SQLModel、Alembic、Playwright等Python生态最佳实践。"
license: MIT
metadata:
  version: 1.0.0
  domains: [backend, python, fastapi, django, flask, api, database]
  type: specialist
  inputs: [api-design, database-schema, python-code, orm-configuration]
---

# Python 后端开发专家

## 当使用此技能

- 开发现代异步 API (FastAPI)
- 构建企业级全栈应用 (Django)
- 创建轻量级微服务 (Flask)
- 设计数据库 ORM (SQLModel/SQLAlchemy)
- 数据验证 (Pydantic)
- 数据库迁移 (Alembic)
- 浏览器自动化 (Playwright)

## 框架选择

| 框架 | 适用场景 |
|------|----------|
| **FastAPI** | 现代 API、异步、自动文档 |
| **Django** | 企业应用、全栈、CMS |
| **Flask** | 微服务、快速原型 |

## 最佳实践

1. **类型注解**: 使用 Python 3.9+ 类型提示
2. **异步优先**: FastAPI 用 async/await
3. **Pydantic 验证**: 所有输入/输出用 BaseModel
4. **Alembic 迁移**: 数据库变更必须迁移
5. **环境配置**: 使用 pydantic-settings
6. **测试覆盖**: pytest + pytest-asyncio

## 触发词

- "开发 Python API"
- "FastAPI 项目"
- "Django 应用"
- "Python 后端"
- "SQLAlchemy ORM"
