---
name: doc-coauthoring
description: "Guide users through a structured workflow for co-authoring documentation. Use when user wants to write documentation, proposals, technical specs, decision docs, or similar structured content. This workflow helps users efficiently transfer context, refine content through iteration, and verify the doc works for readers. Trigger when user mentions writing docs, creating proposals, drafting specs, or similar documentation tasks."
license: MIT
metadata:
  version: 1.0.0
  domains: [documentation, writing, collaboration, workflow]
  type: workflow
---

# 文档协作工作流

## 当使用此技能

- 编写技术文档
- 创建项目提案
- 起草技术规范
- 决策文档
- 结构化内容创作

## 工作流程

### 阶段 1: 上下文转移
- 收集需求和背景
- 确定受众和目标
- 列出关键要点

### 阶段 2: 内容迭代
- 初稿: 快速写出核心内容
- 完善: 添加细节和示例
- 审核: 检查逻辑和流畅性

### 阶段 3: 验证
- 受众测试: 是否易于理解
- 完整性: 是否遗漏关键信息
- 可行性: 是否可执行

## 文档类型

- **技术规范**: API 文档、架构设计
- **提案**: 项目计划、功能建议
- **决策**: ADR、技术选型
- **指南**: 教程、手册

## 最佳实践

- **结构化**: 使用清晰的标题层次
- **示例优先**: 用代码/示例说明
- **迭代优化**: 多次修订完善

## 触发词

- "写文档"
- "创建提案"
- "起草规范"
- "决策文档"
