# 常见表格模式参考

## 1. 实体属性表格

用于展示数据库实体、类的属性定义。

```
表头: 属性名 | 类型/约束 | 说明
数据: field1 | INT, PK | 主键
```

**示例**:
| 属性名 | 类型/约束 | 说明 |
|--------|-----------|------|
| uid | BIGINT, PK | 用户唯一标识 |
| username | VARCHAR(50) | 用户姓名 |
| email | VARCHAR(100), UNIQUE | 邮箱地址 |

## 2. 联系关系表格

用于展示实体间的关联关系（1:1, 1:N, M:N）。

```
表头: 联系 | 实体A | 实体B | 说明
```

**示例**:
| 联系 | 实体A | 实体B | 说明 |
|------|-------|-------|------|
| 用户→元数据 | user | metadata | 一对多 |
| 用户↔设备 | user | device | 多对多(通过user_dev) |

## 3. 技术选型对比表格

```
表头: 技术名称 | 技术简介 | 本项目用途 | 核心特性
```

## 4. 索引汇总表格

```
表头: 表名 | 索引名称 | 索引字段 | 索引类型 | 说明
```

## 5. 规范化检查表格

```
表头: 范式 | 定义 | 检查项 | 实现情况
```

## 6. E-R图转换规则表格

```
表头: 转换规则 | 说明 | 应用示例
```

## 7. 存储路径设计表格

```
表头: 数据类型 | 存储路径格式 | 示例
```
