---
name: frontend-development
description: "前端页面开发。当用户需要开发 Web 应用、创建 UI 组件、实现交互功能或优化前端性能时使用此技能。"
license: MIT
metadata:
  version: 1.0.0
  domains: [frontend, web, ui, react, vue, javascript]
  type: specialist
---

# 前端开发专家

## 当使用此技能

- 开发 Web 应用
- 创建 UI 组件
- 实现交互功能
- 优化前端性能
- 响应式设计
- 状态管理

## 技术栈

- **框架**: React, Vue, Next.js, Nuxt
- **样式**: Tailwind CSS, CSS Modules
- **状态**: Redux, Zustand, Pinia
- **构建**: Vite, Webpack

## 最佳实践

1. **组件化**: 可复用组件设计
2. **响应式**: 移动优先
3. **性能**: 代码分割、懒加载
4. **可访问性**: ARIA 标准
5. **类型安全**: TypeScript

## 能力

- 组件开发 (React/Vue)
- 状态管理
- 路由配置
- API 集成
- 性能优化
- 测试 (Jest, Playwright)

## 触发词

- "前端开发"
- "创建组件"
- "React 应用"
- "Vue 项目"
- "UI 优化"
