# 医疗企业融资监控系统 - 产品需求文档 (PRD)

## 1. 产品概述

### 1.1 产品定位
面向媒体、投资机构的医疗健康行业融资情报系统，通过多数据源监控，**比公开新闻早 3-7 天**发现融资信号。

### 1.2 核心价值
- **时效性**: 工商变更数据比新闻披露早 3-7 天
- **准确性**: 多源交叉验证，降低误报率
- **智能化**: AI 语义理解，不只是关键词匹配
- **自动化**: 7x24 小时监控，实时告警

### 1.3 目标用户
| 用户类型 | 使用场景 | 核心需求 |
|----------|----------|----------|
| 医疗媒体 | 抢发融资新闻 | 时效性、准确性 |
| VC/PE | 发现投资标的 | 早期信号、行业覆盖 |
| 药企 BD | 寻找合作/收购标的 | 精准匹配、深度分析 |

---

## 2. 功能规划

### 2.1 核心功能矩阵

| 功能模块 | 优先级 | 状态 | 数据源 | 价值 |
|----------|--------|------|--------|------|
| 🔔 **工商变更实时告警** | P0 | 🚧 开发中 | 天眼查/企查查 API | 比新闻快 3-7 天 |
| 📰 **新闻信号监控** | P0 | ✅ 已完成 | Firecrawl/新浪财经 | 多源聚合 |
| 📊 **招聘趋势分析** | P1 | 📋 规划中 | Boss直聘/拉勾 | 预测融资可能性 |
| 🐦 **社交信号捕捉** | P1 | 📋 规划中 | Twitter/微博/LinkedIn | 第一时间发现线索 |
| 🔗 **完整信息链** | P0 | ✅ 已完成 | 全部数据源 | 每条信号有源链接 |
| 📈 **融资预测模型** | P2 | 📋 规划中 | 综合数据 | AI 预测融资概率 |

---

## 3. 功能详细设计

### 3.1 🔔 工商变更实时告警 (P0)

#### 3.1.1 功能描述
监控目标企业的工商变更信息，识别融资相关变更，实时推送告警。

#### 3.1.2 融资信号识别规则

**强信号 (置信度 >80%)**
| 变更类型 | 描述 | 权重 |
|----------|------|------|
| 新增机构股东 | 股东名称包含"投资/资本/基金/创投" | +40 |
| 注册资本增加 | 增幅 >10% | +30 |
| 股权稀释 | 创始人持股比例下降 | +20 |

**中信号 (置信度 50-80%)**
| 变更类型 | 描述 | 权重 |
|----------|------|------|
| 新增自然人股东 | 可能是投资人代持 | +15 |
| 经营范围扩大 | 业务扩张信号 | +10 |
| 办公地址变更 | 搬迁到更好区域 | +10 |

#### 3.1.3 数据源
- **天眼查 API**: 工商变更、股东信息、注册资本
- **企查查 API**: 备用数据源，交叉验证

#### 3.1.4 告警模板
```
🚨 **工商变更告警**

**企业**: {{company_name}}
**变更时间**: {{change_date}}
**置信度**: {{confidence}}%

**变更详情**:
- 变更类型: {{change_type}}
- 变更前: {{before}}
- 变更后: {{after}}

**AI 分析**:
- 融资轮次: {{round_estimate}}
- 融资金额: {{amount_estimate}}
- 投资方: {{investors}}

**数据来源**: 天眼查
**源链接**: {{source_url}}
```

#### 3.1.5 技术实现
```python
# 天眼查 API 调用
GET https://open.tianyancha.com/services/open/ic/changeinfo/2.0
Headers: Authorization: {token}
Params: keyword={company_name}

# 返回数据
{
  "changeList": [
    {
      "changeTime": "2026-02-01",
      "changeItem": "股东变更",
      "contentBefore": "张三 100%",
      "contentAfter": "张三 80%, 红杉资本 20%"
    }
  ]
}
```

---

### 3.2 📊 招聘趋势分析 (P1)

#### 3.2.1 功能描述
监控目标企业的招聘信息变化，大规模招聘往往预示融资完成。

#### 3.2.2 信号识别规则
| 信号 | 描述 | 置信度 |
|------|------|--------|
| 职位数量激增 | 周环比增长 >50% | +30 |
| 高管招聘 | CFO/VP/总监级别 | +25 |
| 技术团队扩张 | 研发岗位大量招聘 | +20 |
| 新城市扩张 | 新增招聘城市 | +15 |

#### 3.2.3 数据源
- **Boss直聘**: 职位列表、公司主页
- **拉勾网**: 职位详情、公司规模
- **猎聘**: 高端职位

#### 3.2.4 技术实现
```python
# Playwright 爬取 Boss直聘
async def get_job_count(company_name):
    page = await browser.new_page()
    await page.goto(f"https://www.zhipin.com/gongsi/{company_id}/")
    job_count = await page.query_selector(".job-count")
    return int(job_count.inner_text())

# 趋势分析
def analyze_trend(history):
    current = history[-1]
    last_week = history[-7] if len(history) >= 7 else history[0]
    growth_rate = (current - last_week) / last_week * 100
    return growth_rate
```

---

### 3.3 🐦 社交信号捕捉 (P1)

#### 3.3.1 功能描述
监控创始人、投资人的社交媒体动态，捕捉融资相关线索。

#### 3.3.2 监控目标
| 平台 | 监控对象 | 信号类型 |
|------|----------|----------|
| Twitter/X | 知名投资人 | 投资公告、暗示 |
| 微博 | 创始人、财经大V | 融资消息、庆祝 |
| LinkedIn | 高管 | 职位变动、公司动态 |

#### 3.3.3 关键词监控
```yaml
融资相关:
  - "excited to announce"
  - "thrilled to share"
  - "融资"
  - "投资"
  - "感谢投资人"

投资人动态:
  - "led the round"
  - "proud to back"
  - "portfolio company"
```

#### 3.3.4 数据源
- **Twitter API**: 投资人账号监控
- **微博开放平台**: 关键词搜索
- **LinkedIn**: Playwright 爬取

---

### 3.4 🔗 完整信息链 (P0) ✅

#### 3.4.1 功能描述
每条融资信号都提供完整的信息链，包括源链接、置信度、分析依据。

#### 3.4.2 信息结构
```json
{
  "company": "推想科技",
  "signal_type": "融资新闻",
  "confidence": 95,
  "sources": [
    {
      "name": "36氪",
      "url": "https://36kr.com/p/xxx",
      "title": "推想科技完成B轮融资",
      "publish_time": "2026-02-06 10:00"
    },
    {
      "name": "Firecrawl",
      "url": "https://xxx",
      "title": "...",
      "publish_time": "..."
    }
  ],
  "analysis": {
    "round": "B轮",
    "amount": "1.2亿元",
    "investors": ["启明创投", "红杉中国"],
    "keywords_matched": ["融资", "B轮", "领投"]
  },
  "cross_validation": {
    "sources_count": 2,
    "consistency": "high",
    "confidence_boost": 15
  }
}
```

---

## 4. 数据源配置

### 4.1 已接入

| 数据源 | 类型 | 状态 | 配置 |
|--------|------|------|------|
| Firecrawl | 搜索引擎 | ✅ 正常 | `pass show api/firecrawl` |
| 新浪财经 | 新闻 | ✅ 正常 | 无需配置 |

### 4.2 待接入

| 数据源 | 类型 | 状态 | 配置 |
|--------|------|------|------|
| 天眼查 | 工商信息 | 🚧 配置中 | `pass show api/tianyancha` |
| 企查查 | 工商信息 | 📋 待配置 | `pass show api/qichacha` |
| Boss直聘 | 招聘 | 📋 待开发 | Playwright |
| Twitter | 社交 | 📋 待配置 | API Key |
| 微博 | 社交 | 📋 待开发 | Playwright |

---

## 5. 系统架构

```
┌─────────────────────────────────────────────────────────────────┐
│                         数据采集层                               │
├──────────┬──────────┬──────────┬──────────┬──────────┬─────────┤
│ 天眼查   │ 企查查   │ Firecrawl│ Boss直聘 │ Twitter  │ 微博    │
│ (工商)   │ (工商)   │ (新闻)   │ (招聘)   │ (社交)   │ (社交)  │
└────┬─────┴────┬─────┴────┬─────┴────┬─────┴────┬─────┴────┬────┘
     │          │          │          │          │          │
     ▼          ▼          ▼          ▼          ▼          ▼
┌─────────────────────────────────────────────────────────────────┐
│                         数据清洗层                               │
│  • 去重 (URL/标题相似度)                                         │
│  • 过滤噪音 (融资融券、旧闻)                                     │
│  • 时间标准化                                                    │
│  • 实体识别 (公司名、投资方、金额)                               │
└─────────────────────────┬───────────────────────────────────────┘
                          │
                          ▼
┌─────────────────────────────────────────────────────────────────┐
│                         信号分析层                               │
│  • 关键词匹配 + 语义理解                                         │
│  • 多源交叉验证                                                  │
│  • 置信度评分                                                    │
│  • 融资轮次/金额推断                                             │
└─────────────────────────┬───────────────────────────────────────┘
                          │
                          ▼
┌─────────────────────────────────────────────────────────────────┐
│                         告警推送层                               │
│  • Telegram 实时告警 (高置信度)                                  │
│  • 飞书群组推送                                                  │
│  • 日报/周报生成                                                 │
│  • 完整信息链输出                                                │
└─────────────────────────────────────────────────────────────────┘
```

---

## 6. 里程碑计划

### Phase 1: 基础监控 (已完成 ✅)
- [x] 新闻信号监控 (Firecrawl + 新浪财经)
- [x] 融资信号识别算法
- [x] Telegram 推送
- [x] 完整信息链输出

### Phase 2: 工商数据接入 (进行中 🚧)
- [x] 天眼查 API 配置
- [ ] 天眼查工商变更监控
- [ ] 企查查 API 配置 (备用)
- [ ] 工商变更告警

### Phase 3: 招聘趋势分析 (规划中 📋)
- [ ] Boss直聘爬虫
- [ ] 招聘趋势分析算法
- [ ] 融资预测模型

### Phase 4: 社交信号捕捉 (规划中 📋)
- [ ] Twitter API 接入
- [ ] 微博爬虫
- [ ] 投资人动态监控

---

## 7. 监控企业列表

### 当前监控 (10家)

| 企业 | 类别 | 优先级 | 状态 |
|------|------|--------|------|
| 迈瑞医疗 | 医疗器械 | 中 | 已上市 |
| 联影医疗 | 医疗器械 | 中 | 已上市 |
| 百济神州 | 创新药 | 中 | 已上市 |
| 信达生物 | 创新药 | 中 | 已上市 |
| 推想科技 | 医疗AI | 高 | 未上市 |
| 数坤科技 | 医疗AI | 高 | IPO中 |
| 微医集团 | 互联网医疗 | 高 | IPO中 |
| 丁香园 | 互联网医疗 | 高 | IPO中 |
| 华大基因 | 基因检测 | 中 | 已上市 |
| 燃石医学 | 基因检测 | 高 | 已上市 |

### 建议新增

**医疗AI (高优先级)**
- 深睿医疗、汇医慧影、医渡云、鹰瞳科技

**创新药 (高优先级)**
- 君实生物、再鼎医药、和黄医药、康方生物

---

## 8. API 配置清单

| 数据源 | 配置路径 | 状态 |
|--------|----------|------|
| Firecrawl | `pass show api/firecrawl` | ✅ |
| 天眼查 | `pass show api/tianyancha` | 🚧 待验证 |
| 企查查 | `pass show api/qichacha` | 📋 待配置 |
| Twitter | `pass show api/twitter` | 📋 待配置 |

---

## 9. 成功指标

| 指标 | 目标 | 当前 |
|------|------|------|
| 融资信号发现率 | >90% | 待统计 |
| 误报率 | <20% | 待统计 |
| 平均提前时间 | 3-7 天 | 待统计 |
| 数据源覆盖 | 6+ | 2 |

---

*文档版本: v1.0*
*创建时间: 2026-02-06*
*最后更新: 2026-02-06*
