# 医疗融资信号 - 手动验证清单

当系统检测到融资信号时，使用此清单进行人工验证，确保信息准确性。

---

## 🔍 三级验证体系

### 一级验证（强验证）- 必须全部通过

- [ ] **1.1 国家企业信用信息公示系统确认**
  - 访问：http://www.gsxt.gov.cn
  - 搜索公司全称
  - 检查变更记录
  - 确认变更时间、内容
  - 截图保存证据

- [ ] **1.2 多源数据对比**
  - 天眼查 vs 企查查：信息是否一致？
  - 变更时间是否吻合？
  - 变更内容是否一致？
  - 不一致之处需要进一步核实

- [ ] **1.3 官方公告确认**（如适用）
  - 上市公司：证监会/交易所公告
  - 查询披露易：http://www.cninfo.com.cn
  - 确认是否有融资公告
  - 公告内容与工商变更是否匹配

---

### 二级验证（中验证）- 至少通过 2 项

- [ ] **2.1 媒体报道交叉验证**
  - 搜索："公司名 融资"
  - 36氪、动脉网、投中网
  - 报道时间是否在变更后？
  - 报道内容是否一致？

- [ ] **2.2 招聘数据验证**
  - BOSS直聘、拉勾网
  - 是否有大量新岗位发布？
  - 是否有融资相关岗位（投融资经理）？
  - 发布时间是否在变更后？

- [ ] **2.3 办公地址变更**
  - 是否搬迁到更好的区域？
  - 新办公室规模是否扩大？
  - 是否符合融资扩张特征？

- [ ] **2.4 股权穿透分析**
  - 新股东背景调查
  - 是否为知名投资机构？
  - 是否有政府/国资背景？

---

### 三级验证（弱验证）- 辅助参考

- [ ] **3.1 注册资本增加**
  - 增幅是否 >10%？
  - 是否在合理范围内？

- [ ] **3.2 法人变更**
  - 是否为内部调整？
  - 是否与融资相关？

---

## 📋 验证流程

### 步骤 1：系统告警

系统检测到融资信号 → 推送告警 → 人工介入

### 步骤 2：一级验证（必须）

1. 打开国家企业信用信息公示系统
2. 搜索公司名称
3. 查看变更记录
4. 截图保存

### 步骤 3：二级验证（至少 2 项）

1. 媒体搜索
2. 招聘网站查询
3. 股权背景调查

### 步骤 4：综合评分

| 验证级别 | 通过项 | 置信度 |
|---------|--------|--------|
| 一级全部 + 二级 3+ 项 | 4-5 项 | >90% 真实 |
| 一级全部 + 二级 1-2 项 | 3 项 | 60-80% 较真实 |
| 一级全部 + 二级 0 项 | 2 项 | 50-70% 可疑 |
| 仅三级验证 | 1 项 | <50% 不确定 |

### 步骤 5：验证报告

```markdown
## 融资信号验证报告

**企业**: XX医疗科技有限公司
**变更时间**: 2026-02-05
**检测时间**: 2026-02-07

### 一级验证
- [✅] 国家企业信用公示：确认
- [✅] 多源对比：一致
- [❌] 官方公告：不适用

### 二级验证
- [✅] 媒体报道：36氪报道
- [✅] 招聘数据：新增 15 个岗位
- [❌] 办公地址：无变更
- [✅] 股权穿透：红杉资本

### 综合评分
- 通过项: 5 项
- 置信度: 85%
- 结论: **较真实，建议跟进**

### 备注
媒体报道：[链接]
招聘截图：[附件]
```

---

## 🚨 常见陷阱

### 陷阱 1：内部增资
- **特征**: 仅注册资本增加，无新股东
- **识别**: 检查股东列表，看是否有新增
- **判断**: 可能是内部调整，不是外部融资

### 陷阱 2：股权转让
- **特征**: 股东变更，但注册资本不变
- **识别**: 检查转让方和受让方关系
- **判断**: 可能是股东退出，不是融资

### 陷阱 3：数据延迟
- **特征**: 各平台更新时间不一致
- **识别**: 以官方公示系统为准
- **判断**: 其他平台数据可能滞后

### 陷阱 4：虚假宣传
- **特征**: 媒体报道但无工商变更
- **识别**: 以工商变更为准
- **判断**: 可能是 PR 行为

---

## 📚 参考资源

### 官方数据源
- 国家企业信用信息公示系统: http://www.gsxt.gov.cn
- 证监会披露易: http://www.cninfo.com.cn
- 上交所: http://www.sse.com.cn
- 深交所: http://www.szse.cn

### 商业数据源
- 天眼查: https://www.tianyancha.com
- 企查查: https://www.qcc.com
- 启信宝: https://www.qixin.com

### 媒体验证
- 36氪: https://36kr.com
- 动脉网: https://www.vbdata.cn
- 投中网: https://www.chinaventure.com.cn

### 招聘验证
- BOSS直聘: https://www.zhipin.com
- 拉勾网: https://www.lagou.com
- LinkedIn: https://www.linkedin.com

---

## ✅ 快速验证模板

复制以下模板进行快速验证：

```
公司: ___________________
变更日期: _____________

一级验证:
□ 官方公示: [ ]是 [ ]否  截图: _______
□ 多源对比: [ ]一致 [ ]不一致
□ 官方公告: [ ]是 [ ]否  链接: _______

二级验证:
□ 媒体报道: [ ]是 [ ]否  链接: _______
□ 招聘数据: [ ]是 [ ]否  数量: _____
□ 办公地址: [ ]有变更 [ ]无变更
□ 股权穿透: [ ]知名机构 [ ]不明

综合评分:
- 通过项: _____ / 7
- 置信度: _____%
- 结论: [ ]真实 [ ]较真实 [ ]可疑 [ ]不确定
```

---

*版本: v1.0*
*创建日期: 2026-02-07*
*作者: 小a (Opus 4.6)*
