# MCP Manager

智能管理 MCP (Model Context Protocol) 服务器，提供自动检测、智能开关和功能问答。

## 快速开始

### 1. 安装

将此 skill 添加到你的 skills 目录：

```bash
cd ~/clawd/skills
git clone https://github.com/yourusername/mcp-manager.git
```

### 2. 使用

```bash
# 查看所有 MCP
cd ~/clawd/skills/mcp-manager
./mcp list

# 检查健康状态
./mcp health check

# 查看特定 MCP 功能
./mcp show github

# 为任务推荐 MCP
./mcp recommend 网页自动化
```

## 命令参考

### 健康检测
```bash
./mcp health check              # 检查所有 MCP
./mcp health check github      # 检查特定 MCP
./mcp health monitor           # 持续监控
```

### 管理操作
```bash
./mcp list                     # 列出所有 MCP
./mcp show <name>             # 显示 MCP 功能
./mcp recommend <task>        # 推荐适合的 MCP
./mcp enable <name>           # 启用 MCP
./mcp disable <name>          # 禁用 MCP
```

## MCP 功能库

### chrome-devtools
- **用途**: 网页自动化、测试、数据抓取
- **资源占用**: 高 (~200MB)
- **优先级**: 低（可自动关闭）

### github
- **用途**: 代码搜索、仓库分析、协作信息
- **资源占用**: 低 (~50MB)
- **优先级**: 中

### context7
- **用途**: 长期记忆、上下文保持、知识管理
- **资源占用**: 低 (~50MB)
- **优先级**: 中

### filesystem
- **用途**: 文件操作、代码生成、文档处理
- **资源占用**: 低 (~20MB)
- **优先级**: 高（始终保持启用）

## 示例输出

### 健康检查
```bash
$ ./mcp health check

🔍 MCP Health Check
==================================================

✅ chrome-devtools
   Status: OK (45ms)
   Command: npx

✅ github
   Status: OK (120ms)
   Command: npx

✅ context7
   Status: OK (89ms)
   Command: npx

📊 Summary: OK: 3, Errors: 0, Total: 3
```

### 功能展示
```bash
$ ./mcp show github

🎯 github
============================================================

GitHub MCP - GitHub 仓库操作工具

✅ 能做什么：
  📂 搜索仓库和代码
  🔍 查看 Issue 和 PR
  📊 获取仓库统计信息
  🌿 分支和标签管理
  👥 用户和仓库信息查询
  📝 查看 README 和文档

❌ 不能做什么：
  ❌ 修改代码（只读操作）
  ❌ 创建/删除仓库
  ❌ 管理 Issues（需要额外权限）
  ❌ 执行 Git 命令

💡 适用场景：
  • 代码搜索
  • 仓库分析
  • 协作信息查询
  • 开源项目调研

📊 资源占用: Low (~50MB)
⚡ 优先级: medium
```

### 推荐 MCP
```bash
$ ./mcp recommend 网页自动化

🤔 任务: 网页自动化
============================================================

💡 推荐使用的 MCP：
  • chrome-devtools - Chrome DevTools MCP - 浏览器自动化工具
```

## 配置

编辑 `scripts/mcp_manager.py` 中的 `MCP_CAPABILITIES` 来添加或修改 MCP 定义。

## 故障排查

### 健康检查失败
```bash
# 查看详细错误
./mcp health check github --debug
```

### MCP 无法启动
```bash
# 检查配置
cat ~/.claude.json | grep -A 10 github

# 确认命令可用
which npx
```

## 贡献

欢迎提交 Issue 和 PR！

## 许可

MIT
