---
name: project-management
description: 项目管理和产品需求分析。当用户需要制定项目计划、编写 PRD 文档、管理任务或进行需求分析时使用此技能。
allowed-tools: Read, Write, Edit, TodoWrite, WebSearch
---

# 项目管理与产品需求

## 功能说明
此技能专门用于项目管理和产品需求分析,包括:
- 产品需求文档(PRD)编写
- 项目计划制定
- 任务分解和优先级排序
- 用户故事和验收标准
- 风险识别和管理
- 敏捷开发流程

## 使用场景
- "编写一个电商系统的 PRD"
- "制定项目开发计划"
- "分解功能模块和任务"
- "定义用户故事和验收标准"
- "评估项目风险"
- "规划 MVP 功能"

## 核心能力

### 1. 需求洞察与分析
- 精准识别真实用户需求
- 区分核心功能和增值功能
- 基于场景的产品设计
- 竞品分析和差异化定位

### 2. 功能分解
- 将宏观需求拆解为可执行的功能点
- 定义输入-处理-输出逻辑
- 识别依赖关系和集成点
- 处理边界情况和异常

### 3. 优先级管理
- **P0(Must Have)**:MVP 必需功能
- **P1(Should Have)**:重要但非必需
- **P2(Nice to Have)**:锦上添花功能

### 4. 风险预判
- 技术实现风险
- 市场接受度风险
- 用户采用风险
- 资源和时间风险

## PRD 文档结构

### 标准 PRD 模板

```markdown
# [产品名称] 产品需求文档(PRD)

**版本**: v1.0
**创建日期**: 2025-01-01
**作者**: 产品经理
**状态**: 草稿/评审中/已批准

---

## 1. 项目背景与目标

### 1.1 产品愿景
简明扼要地描述产品的核心价值主张和长期愿景。

### 1.2 问题陈述
**当前痛点**:
- 用户面临的具体问题
- 问题的严重程度和影响范围
- 现有解决方案的不足

**目标用户**:
- 主要用户群体(年龄、职业、行为特征)
- 次要用户群体
- 用户画像和典型场景

### 1.3 成功指标(KPI)
- **用户指标**: DAU、MAU、留存率
- **业务指标**: GMV、转化率、客单价
- **产品指标**: 功能使用率、完成率
- **技术指标**: 响应时间、可用性

### 1.4 业务目标与约束
**业务目标**:
- 短期目标(3 个月)
- 中期目标(6-12 个月)
- 长期目标(1-3 年)

**已知约束**:
- 技术限制
- 预算限制
- 时间限制
- 平台限制(iOS/Android/Web)

---

## 2. 用户研究与竞品分析

### 2.1 用户画像
**主要用户: 职场白领**
- 年龄: 25-35 岁
- 职业: 互联网、金融、咨询行业
- 痛点: 时间管理困难、工作效率低
- 期望: 简单易用、提高生产力

### 2.2 用户旅程
```
发现问题 → 寻找解决方案 → 注册使用 → 日常使用 → 推荐他人
```

### 2.3 竞品分析
| 竞品 | 优势 | 劣势 | 差异化机会 |
|------|------|------|------------|
| 产品 A | 功能丰富 | 学习成本高 | 简化操作流程 |
| 产品 B | 界面美观 | 性能较差 | 优化性能体验 |

---

## 3. 功能需求

### 3.1 功能架构图
```
├── 用户模块
│   ├── 注册登录
│   ├── 个人资料
│   └── 账号设置
├── 核心功能模块
│   ├── 功能 A
│   ├── 功能 B
│   └── 功能 C
└── 辅助功能模块
    ├── 通知中心
    └── 帮助中心
```

### 3.2 用户故事列表

| ID | 用户故事 | 优先级 | 验收标准 | 依赖 |
|----|----------|--------|----------|------|
| US-001 | 作为用户,我希望能够快速注册账号,以便开始使用产品 | P0 | 1. 支持邮箱/手机注册<br>2. 注册流程不超过 3 步<br>3. 注册成功后自动登录 | 无 |
| US-002 | 作为用户,我希望能够安全登录,以便访问我的数据 | P0 | 1. 支持密码登录<br>2. 支持第三方登录<br>3. 登录失败有明确提示 | US-001 |
| US-003 | 作为用户,我希望能够创建任务,以便管理我的工作 | P0 | 1. 可以输入任务标题和描述<br>2. 可以设置截止日期<br>3. 任务创建后立即显示 | US-002 |

### 3.3 功能详细说明

#### 功能模块: 用户注册

**功能描述**:
用户通过邮箱或手机号注册账号,完成身份验证后即可使用产品。

**交互流程**:
1. 用户点击"注册"按钮
2. 选择注册方式(邮箱/手机)
3. 输入注册信息
4. 接收验证码
5. 完成验证
6. 设置密码
7. 注册成功,自动登录

**界面要素**:
- 注册方式选择(Tab 切换)
- 邮箱/手机号输入框
- 验证码输入框
- 密码输入框(带强度提示)
- 同意条款复选框
- 注册按钮

**数据字段**:
| 字段名 | 类型 | 必填 | 验证规则 | 说明 |
|--------|------|------|----------|------|
| email | String | 是 | 邮箱格式 | 用户邮箱 |
| phone | String | 是 | 手机号格式 | 用户手机 |
| password | String | 是 | 6-20 位,包含字母和数字 | 登录密码 |
| verifyCode | String | 是 | 6 位数字 | 验证码 |

**业务规则**:
- 邮箱/手机号不能重复注册
- 验证码 5 分钟内有效
- 密码必须包含字母和数字
- 同一 IP 每天最多注册 3 个账号

**异常处理**:
- 邮箱/手机号已存在: 提示"该账号已注册,请直接登录"
- 验证码错误: 提示"验证码错误,请重新输入"
- 验证码过期: 提示"验证码已过期,请重新获取"
- 网络错误: 提示"网络连接失败,请稍后重试"

**接口定义**:
```
POST /api/auth/register
Request:
{
  "email": "user@example.com",
  "password": "password123",
  "verifyCode": "123456"
}

Response:
{
  "success": true,
  "data": {
    "userId": 12345,
    "token": "jwt_token_here"
  },
  "message": "注册成功"
}
```

---

## 4. 非功能需求

### 4.1 性能要求
- **响应时间**: 页面加载 < 2 秒,API 响应 < 500ms
- **并发能力**: 支持 10,000 并发用户
- **可扩展性**: 支持水平扩展

### 4.2 安全要求
- **认证**: JWT Token 认证,7 天有效期
- **授权**: 基于角色的访问控制(RBAC)
- **数据加密**: HTTPS 传输,敏感数据加密存储
- **防护**: SQL 注入、XSS、CSRF 防护

### 4.3 兼容性要求
- **浏览器**: Chrome 90+, Safari 14+, Firefox 88+
- **移动端**: iOS 13+, Android 8+
- **屏幕**: 支持 320px - 1920px 宽度

### 4.4 可用性要求
- **系统可用性**: 99.9% (每月停机时间 < 43 分钟)
- **数据备份**: 每日全量备份,实时增量备份
- **灾难恢复**: RTO < 1 小时,RPO < 5 分钟

### 4.5 可维护性要求
- **代码规范**: 遵循团队编码规范
- **文档**: 完整的 API 文档和技术文档
- **日志**: 完善的日志记录和监控
- **测试**: 单元测试覆盖率 > 80%

---

## 5. 技术方案(可选)

### 5.1 技术架构
```
前端: React + TypeScript + Ant Design
后端: Node.js + Express + TypeScript
数据库: MySQL + Redis
部署: Docker + Kubernetes
```

### 5.2 数据库设计
```sql
-- 用户表
CREATE TABLE users (
  id BIGINT PRIMARY KEY AUTO_INCREMENT,
  email VARCHAR(255) UNIQUE,
  phone VARCHAR(20) UNIQUE,
  password_hash VARCHAR(255),
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
```

---

## 6. 项目计划

### 6.1 里程碑
| 阶段 | 时间 | 交付物 | 负责人 |
|------|------|--------|--------|
| 需求评审 | Week 1 | PRD 文档 | 产品经理 |
| 设计评审 | Week 2 | UI 设计稿 | 设计师 |
| 开发 | Week 3-6 | 功能代码 | 开发团队 |
| 测试 | Week 7 | 测试报告 | 测试团队 |
| 上线 | Week 8 | 生产环境 | 运维团队 |

### 6.2 任务分解
**Phase 1: MVP 核心功能(P0)**
- [ ] 用户注册登录
- [ ] 核心功能 A
- [ ] 核心功能 B

**Phase 2: 重要功能(P1)**
- [ ] 功能 C
- [ ] 功能 D

**Phase 3: 增强功能(P2)**
- [ ] 功能 E
- [ ] 功能 F

---

## 7. 风险与应对

### 7.1 技术风险
| 风险 | 影响 | 概率 | 应对措施 |
|------|------|------|----------|
| 第三方 API 不稳定 | 高 | 中 | 实现降级方案,添加重试机制 |
| 性能瓶颈 | 中 | 低 | 提前进行压力测试,优化关键路径 |

### 7.2 业务风险
| 风险 | 影响 | 概率 | 应对措施 |
|------|------|------|----------|
| 用户接受度低 | 高 | 中 | 小范围灰度测试,收集反馈快速迭代 |
| 竞品抢先发布 | 中 | 低 | 加快开发进度,突出差异化优势 |

---

## 8. 验收标准

### 8.1 功能验收
- [ ] 所有 P0 功能完整实现
- [ ] 所有用户故事的验收标准通过
- [ ] 无阻塞性 Bug

### 8.2 性能验收
- [ ] 页面加载时间 < 2 秒
- [ ] API 响应时间 < 500ms
- [ ] 并发测试通过

### 8.3 安全验收
- [ ] 通过安全扫描
- [ ] 无高危漏洞
- [ ] 数据加密正确实施

---

## 9. 附录

### 9.1 术语表
- **DAU**: Daily Active Users,日活跃用户数
- **MAU**: Monthly Active Users,月活跃用户数
- **MVP**: Minimum Viable Product,最小可行产品

### 9.2 参考资料
- [竞品分析报告]
- [用户调研报告]
- [技术选型文档]

### 9.3 变更记录
| 版本 | 日期 | 变更内容 | 变更人 |
|------|------|----------|--------|
| v1.0 | 2025-01-01 | 初始版本 | 张三 |
| v1.1 | 2025-01-15 | 增加功能 X | 李四 |
```

## 敏捷开发流程

### Scrum 框架
```markdown
Sprint 周期: 2 周

Sprint 流程:
1. Sprint Planning(计划会议)
   - 确定 Sprint 目标
   - 选择用户故事
   - 任务分解和估算

2. Daily Standup(每日站会)
   - 昨天完成了什么
   - 今天计划做什么
   - 遇到什么阻碍

3. Sprint Review(评审会议)
   - 演示完成的功能
   - 收集反馈
   - 更新产品待办列表

4. Sprint Retrospective(回顾会议)
   - 总结做得好的地方
   - 识别改进机会
   - 制定行动计划
```

### 用户故事格式
```markdown
作为 [用户角色]
我希望 [功能描述]
以便 [价值/目标]

验收标准:
- [ ] 标准 1
- [ ] 标准 2
- [ ] 标准 3

估算: 5 故事点
优先级: P0
依赖: US-001
```

## 项目管理工具

### 推荐工具
- **Jira**: 敏捷项目管理
- **Trello**: 看板管理
- **Asana**: 任务协作
- **Notion**: 文档和知识库
- **Confluence**: 团队协作文档
- **Figma**: 设计协作
- **GitHub Projects**: 代码项目管理

### 文档管理
```markdown
项目文档结构:
├── PRD/
│   ├── 产品需求文档.md
│   └── 功能规格说明.md
├── Design/
│   ├── UI 设计稿
│   └── 交互原型
├── Tech/
│   ├── 技术方案.md
│   ├── API 文档.md
│   └── 数据库设计.md
├── Test/
│   ├── 测试计划.md
│   └── 测试用例.md
└── Release/
    ├── 发布计划.md
    └── 上线检查清单.md
```

## 最佳实践

### 需求收集
- 与利益相关者深入沟通
- 观察用户实际使用场景
- 分析数据和用户反馈
- 研究竞品和行业趋势

### 需求分析
- 区分需求和解决方案
- 识别真实的用户痛点
- 评估需求的价值和成本
- 考虑技术可行性

### 需求管理
- 建立需求优先级体系
- 定期评审和更新需求
- 管理需求变更
- 保持需求可追溯性

### 沟通协作
- 定期同步项目进展
- 及时解决阻碍问题
- 保持文档更新
- 建立反馈机制

## 注意事项
- 始终以用户价值为中心
- 避免过度设计和功能堆砌
- 保持需求文档的清晰和可执行性
- 及时响应需求变更
- 平衡理想和现实
- 重视团队协作和沟通
- 持续学习和改进
