# 평가 기준 가이드

의사결정 유형별 권장 평가 기준.

## 라이브러리/프레임워크 선택

| 기준 | 설명 | 측정 방법 |
|------|------|-----------|
| **성능** | 속도, 메모리 사용량, 번들 크기 | 벤치마크, 공식 문서 |
| **학습 곡선** | 팀이 익히는 데 걸리는 시간 | 문서 품질, 튜토리얼 양, 개념 복잡도 |
| **생태계** | 플러그인, 확장, 서드파티 도구 | npm 패키지 수, GitHub stars |
| **커뮤니티** | 활성도, 질문 답변 속도 | Stack Overflow 질문 수, Discord/Slack 활성도 |
| **유지보수성** | 장기 지원, 업데이트 빈도 | 릴리스 주기, 이슈 해결 속도 |
| **타입 지원** | TypeScript 지원 수준 | 내장 타입, @types 품질 |
| **문서화** | 공식 문서 품질 | 예제 풍부함, 최신성, 검색 가능성 |
| **채택률** | 업계 사용 현황 | npm 다운로드, 기업 사용 사례 |

### 가중치 예시

**스타트업 (빠른 개발 중시)**:
- 학습 곡선: 30%
- 생태계: 25%
- 문서화: 20%
- 성능: 15%
- 유지보수성: 10%

**엔터프라이즈 (안정성 중시)**:
- 유지보수성: 30%
- 타입 지원: 20%
- 커뮤니티: 20%
- 성능: 15%
- 문서화: 15%

---

## 아키텍처 패턴 결정

| 기준 | 설명 | 측정 방법 |
|------|------|-----------|
| **확장성** | 부하 증가 시 대응 용이성 | 수평/수직 확장 가능 여부 |
| **복잡도** | 구현 및 운영 복잡도 | 필요한 인프라, 학습 비용 |
| **팀 규모 적합성** | 팀 크기에 맞는지 | Conway's Law 고려 |
| **배포 용이성** | CI/CD 복잡도 | 파이프라인 단계 수 |
| **장애 격리** | 부분 장애 시 전체 영향 | 독립 배포 가능 여부 |
| **데이터 일관성** | 트랜잭션 처리 | ACID vs Eventually Consistent |
| **운영 비용** | 인프라 및 인력 비용 | 서버 수, DevOps 필요 인력 |
| **개발 속도** | 초기 개발 ~ MVP | 보일러플레이트, 설정 복잡도 |

### 가중치 예시

**초기 스타트업 (MVP)**:
- 개발 속도: 35%
- 복잡도: 25%
- 운영 비용: 20%
- 확장성: 10%
- 기타: 10%

**성장기 (스케일업)**:
- 확장성: 30%
- 장애 격리: 20%
- 팀 규모 적합성: 20%
- 배포 용이성: 15%
- 운영 비용: 15%

---

## 구현 방식 결정

| 기준 | 설명 | 측정 방법 |
|------|------|-----------|
| **구현 복잡도** | 코드 양, 난이도 | LoC, 추상화 수준 |
| **테스트 용이성** | 단위/통합 테스트 작성 난이도 | 모킹 필요성, 의존성 |
| **디버깅 용이성** | 문제 추적 난이도 | 로깅, 트레이싱 지원 |
| **성능 특성** | 지연시간, 처리량 | 벤치마크 |
| **리소스 사용** | CPU, 메모리, 네트워크 | 프로파일링 |
| **기존 코드 호환** | 현재 아키텍처와 맞는지 | 리팩토링 필요량 |
| **유지보수성** | 장기 관리 용이성 | 코드 가독성, 문서화 |

---

## 데이터베이스 선택

| 기준 | 설명 | 측정 방법 |
|------|------|-----------|
| **데이터 모델** | 관계형/문서형/그래프/키-값 | 요구사항 매칭 |
| **쿼리 유연성** | 복잡한 쿼리 지원 | SQL/NoSQL 기능 |
| **확장성** | 수평 확장 용이성 | 샤딩, 레플리케이션 |
| **일관성** | ACID vs BASE | 트랜잭션 요구사항 |
| **성능** | 읽기/쓰기 속도 | 벤치마크 |
| **운영 복잡도** | 관리 오버헤드 | 백업, 모니터링, 마이그레이션 |
| **비용** | 라이선스, 인프라 | TCO 계산 |
| **에코시스템** | ORM, 드라이버, 도구 | 지원 언어/프레임워크 |

---

## 상황별 추천 기준

### "빠르게 MVP 만들어야 해"
우선순위: 학습 곡선 > 개발 속도 > 문서화 > 나머지

### "대규모 트래픽 예상"
우선순위: 성능 > 확장성 > 운영 비용 > 나머지

### "팀이 작아 (1-3명)"
우선순위: 복잡도 낮음 > 문서화 > 커뮤니티 > 나머지

### "엔터프라이즈 환경"
우선순위: 보안 > 유지보수성 > 타입 지원 > 나머지

### "레거시 시스템 통합"
우선순위: 기존 코드 호환 > 마이그레이션 용이성 > 나머지

---

## 신뢰도 평가 기준

정보 출처별 신뢰도:

| 출처 | 신뢰도 | 비고 |
|------|--------|------|
| 공식 문서 | 높음 | 정확하나 편향 가능 |
| 벤치마크 (독립) | 높음 | 조건 확인 필요 |
| GitHub Issues | 중간-높음 | 실제 사용 경험 |
| Stack Overflow | 중간 | 날짜 확인 필요 |
| Reddit/HN | 중간 | 다양한 관점, 노이즈 있음 |
| 블로그 | 낮음-중간 | 작성자 배경 확인 |
| 마케팅 자료 | 낮음 | 편향됨 |

**신뢰도 높이는 방법**:
- 여러 출처에서 동일한 정보 확인
- 최신 날짜 우선
- 실제 사용 경험 기반 의견 우선
- 벤치마크는 조건/환경 확인
