# Competitive Battlecard Template

A fill-in-the-blank template for creating competitive battlecards that equip sales, marketing, and content teams with actionable intelligence. Maintain one battlecard per major competitor and review quarterly.

## Overview

A competitive battlecard is a concise reference document that summarizes a competitor's strengths, weaknesses, positioning, and how to compete against them. Battlecards are living documents that should be updated as competitors evolve.

**Audience:** Sales teams, content strategists, marketing leadership
**Update frequency:** Quarterly review minimum; update immediately on major competitor changes
**Length target:** 2-3 pages per competitor (scannable, not exhaustive)

---

## Battlecard Template

### Header

```
COMPETITIVE BATTLECARD: [Competitor Name]
Last Updated: [Date]
Updated By: [Name/Team]
Confidence Level: [High/Medium/Low] — based on data recency and source quality
```

---

### Section 1: Competitor Overview

| Field | Details |
|-------|---------|
| **Company Name** | [Name] |
| **Website** | [URL] |
| **Founded** | [Year] |
| **Headquarters** | [Location] |
| **Company Size** | [Employees] |
| **Funding/Revenue** | [Known funding rounds or estimated revenue] |
| **Target Customer** | [Primary audience: SMB, mid-market, enterprise, etc.] |
| **Pricing Model** | [Freemium, subscription, usage-based, custom, etc.] |
| **Pricing Range** | [Entry price → Enterprise price] |

**One-Sentence Summary:**
> [Competitor] is a [category] that helps [target audience] to [primary benefit] by [mechanism].

---

### Section 2: Their Pitch

**Tagline/Slogan:**
> [Their exact tagline from website]

**Top 3 Claimed Differentiators:**
1. [Differentiator 1 — their claim, not your assessment]
2. [Differentiator 2]
3. [Differentiator 3]

**Positioning Statement (Reverse-Engineered):**
> For [their target audience], [product] is the [category] that [key benefit] because [reason to believe].

**Key Messages They Repeat:**
- [Message 1 — found in blog, ads, sales decks]
- [Message 2]
- [Message 3]

---

### Section 3: Strengths (Be Honest)

Credibility depends on honestly assessing where competitors are genuinely strong. Sugarcoating weaknesses or ignoring strengths reduces trust in the battlecard.

| Strength | Evidence | Impact on Deals |
|----------|---------|----------------|
| [Strength 1] | [Where you observed this — reviews, demos, customer feedback] | [How this affects your competitive win rate] |
| [Strength 2] | [Evidence] | [Impact] |
| [Strength 3] | [Evidence] | [Impact] |

---

### Section 4: Weaknesses

| Weakness | Evidence | How to Exploit |
|----------|---------|---------------|
| [Weakness 1] | [Sources: G2 reviews, customer complaints, technical limitations] | [Talking point or demo moment that highlights this gap] |
| [Weakness 2] | [Evidence] | [How to exploit] |
| [Weakness 3] | [Evidence] | [How to exploit] |

**Common Complaints (from review sites):**
- "[Exact quote from G2/Capterra/TrustRadius]" — [Source, Date]
- "[Exact quote]" — [Source, Date]
- "[Exact quote]" — [Source, Date]

---

### Section 5: Your Differentiators

For each differentiator, provide the claim AND the proof. Unsupported claims erode credibility.

| Differentiator | Your Advantage | Proof Point | How to Demo/Show |
|---------------|---------------|------------|-----------------|
| [Differentiator 1] | [What you do better] | [Data, testimonial, or demo evidence] | [Specific demo step or slide] |
| [Differentiator 2] | [What you do better] | [Proof] | [How to show] |
| [Differentiator 3] | [What you do better] | [Proof] | [How to show] |

---

### Section 6: Feature Comparison

| Feature/Capability | You | [Competitor] | Notes |
|-------------------|-----|-------------|-------|
| [Feature 1] | [Yes/No/Partial + detail] | [Yes/No/Partial + detail] | [Context] |
| [Feature 2] | [Yes/No/Partial] | [Yes/No/Partial] | [Context] |
| [Feature 3] | [Yes/No/Partial] | [Yes/No/Partial] | [Context] |
| [Feature 4] | [Yes/No/Partial] | [Yes/No/Partial] | [Context] |
| [Feature 5] | [Yes/No/Partial] | [Yes/No/Partial] | [Context] |
| [Integration A] | [Yes/No] | [Yes/No] | [Context] |
| [Integration B] | [Yes/No] | [Yes/No] | [Context] |

---

### Section 7: Pricing Comparison

| Tier | You | [Competitor] | Advantage |
|------|-----|-------------|-----------|
| Entry/Free | [Price + what's included] | [Price + what's included] | [Who wins at this tier and why] |
| Mid-tier | [Price + what's included] | [Price + what's included] | [Who wins] |
| Enterprise | [Price + what's included] | [Price + what's included] | [Who wins] |

**Hidden Costs to Highlight:**
- [Competitor charges extra for X, which you include]
- [Competitor requires Y add-on for common use case]
- [Competitor's pricing scales poorly because Z]

---

### Section 8: Objection Handling

| When They Say... | You Respond With... | Supporting Evidence |
|-----------------|--------------------|--------------------|
| "[Competitor] has more features" | "[Your response — focus on outcomes, not feature count]" | [Case study, data point, or demo] |
| "[Competitor] is cheaper" | "[Your response — focus on total value, ROI, or hidden costs]" | [TCO comparison, customer quote] |
| "[Competitor] is more established" | "[Your response — focus on innovation, agility, or support quality]" | [Growth metrics, customer satisfaction data] |
| "We're already using [Competitor]" | "[Your response — focus on switching ease, quick wins, or pain points]" | [Migration case study, time-to-value data] |
| "[Competitor] integrates with [tool]" | "[Your response — confirm your integration or alternative]" | [Integration docs, workaround, or roadmap] |

---

### Section 9: Landmine Questions

Questions to ask prospects early in the sales process that highlight your advantages and surface competitor weaknesses. Use these in discovery calls.

| Landmine Question | What It Exposes | Your Advantage |
|------------------|----------------|---------------|
| "How important is [capability you have, they don't] to your workflow?" | Creates need for your differentiator | [Your capability] |
| "Have you experienced [common pain point with competitor]?" | Surfaces known competitor weakness | [Your solution to that pain] |
| "What's your timeline for seeing ROI from this tool?" | Highlights time-to-value differences | [Your faster time-to-value] |
| "How does your team currently handle [use case you excel at]?" | Opens discussion where you shine | [Your approach to this use case] |

---

### Section 10: Win/Loss Analysis

| Theme | Win Reasons (Why We Won) | Loss Reasons (Why We Lost) |
|-------|------------------------|---------------------------|
| Product | [What product features drove the win] | [What product gaps caused the loss] |
| Pricing | [Price advantage or value perception] | [Price disadvantage or perceived poor value] |
| Relationship | [Sales process, support quality] | [Better existing relationship with competitor] |
| Brand | [Brand trust, market perception] | [Competitor brand stronger in this segment] |

**Recent Win Story:**
> [Brief narrative: who was the customer, what were they comparing, why did they choose you]

**Recent Loss Story:**
> [Brief narrative: who was the customer, what were they comparing, why did they choose competitor]

---

### Section 11: SEO/Content Intelligence

| Dimension | [Competitor] | Your Position |
|-----------|-------------|--------------|
| Domain Authority/Rating | [Score] | [Score] |
| Organic traffic (est.) | [Monthly visits] | [Monthly visits] |
| Keywords in top 10 | [Count] | [Count] |
| Top-performing content | [URL + topic] | [Your equivalent or gap] |
| Content publishing cadence | [Posts/month] | [Posts/month] |
| Backlink count | [Count] | [Count] |
| AI citation frequency | [High/Medium/Low] | [High/Medium/Low] |

**Content Strategy Observations:**
- [What content themes drive their traffic]
- [What formats they use effectively]
- [Where their content is weak or outdated]

---

## Battlecard Maintenance Guidelines

### Update Triggers

Update the battlecard immediately when any of these occur:

| Trigger | What to Update |
|---------|---------------|
| Competitor launches new feature | Feature comparison, differentiators, landmine questions |
| Competitor changes pricing | Pricing comparison, objection handling |
| Competitor raises funding / IPO | Overview section, positioning |
| Major review trends change | Weaknesses, objection handling, win/loss |
| You launch competing feature | Differentiators, feature comparison |
| Significant win or loss against them | Win/loss analysis, objection handling |
| Competitor publishes major content | SEO/content intelligence |

### Quarterly Review Checklist

- [ ] Verify all pricing information is current
- [ ] Check for new features launched by competitor
- [ ] Review latest G2/Capterra/TrustRadius reviews for new themes
- [ ] Update win/loss analysis with recent deals
- [ ] Refresh SEO/content metrics
- [ ] Confirm differentiators are still accurate
- [ ] Test all landmine questions with sales team for relevance
- [ ] Archive outdated information (don't delete -- move to "Historical" section)

### Data Sources for Battlecard Updates

| Source | What to Gather | Update Frequency |
|--------|---------------|-----------------|
| Competitor website | Pricing, features, messaging, positioning | Monthly |
| G2/Capterra reviews | Strengths, weaknesses, customer sentiment | Quarterly |
| LinkedIn/social media | Team changes, company news, content strategy | Monthly |
| Industry press/blogs | Funding, partnerships, market perception | As published |
| Sales team feedback | Win/loss themes, objection patterns | Monthly |
| SEO tools | Traffic, rankings, backlinks, content changes | Monthly |
| AI system queries | AI citation patterns, brand mentions | Quarterly |
| Customer feedback | Competitive switching reasons | Quarterly |

---

## Example: Populated Battlecard Header

```
COMPETITIVE BATTLECARD: SEMrush
Last Updated: 2026-02-01
Updated By: Content Strategy Team
Confidence Level: High

One-Sentence Summary:
SEMrush is an all-in-one SEO and digital marketing platform that helps marketing
professionals manage SEO, PPC, content, and social media campaigns from a single dashboard.

Tagline: "Online Marketing Can Be Easy"

Positioning Statement:
For digital marketing professionals and agencies, SEMrush is the all-in-one marketing
toolkit that provides competitive intelligence and workflow automation because it combines
55+ tools across SEO, PPC, content, and social in one platform.
```
