# Gap Analysis Frameworks

Complete frameworks for systematic keyword gap identification, content format gap analysis, funnel stage gap mapping, opportunity scoring models, and content calendar integration. Use these frameworks to transform gap analysis from ad-hoc observation into repeatable process.

## Overview

Content gap analysis answers three questions:
1. **What are competitors covering that you are not?** (Keyword and topic gaps)
2. **What content formats are expected but missing?** (Format gaps)
3. **Where in the buyer journey does your content fail?** (Funnel gaps)

This reference provides structured methodologies for each question, plus scoring and prioritization systems.

---

## 1. Systematic Keyword Gap Methodology

### Step-by-Step Process

#### Step 1: Define Your Keyword Universe

Before finding gaps, establish what you already rank for:

| Data Source | What It Provides | How to Collect |
|------------|-----------------|---------------|
| ~~search console | Keywords driving impressions and clicks to your site | Export Performance report (last 6 months) |
| ~~SEO tool | Full keyword profile including positions 1-100 | Domain keyword export |
| Content audit | Topics covered by existing content | Manual or automated URL crawl + categorization |

**Output:** A master list of all keywords you currently rank for (positions 1-100).

#### Step 2: Build Competitor Keyword Profiles

For each competitor (3-5 recommended):

| Competitor | Total Keywords | Keywords in Top 10 | Keywords in Top 3 | Estimated Traffic |
|-----------|---------------|-------------------|-------------------|------------------|
| [Competitor A] | [Count] | [Count] | [Count] | [Monthly est.] |
| [Competitor B] | [Count] | [Count] | [Count] | [Monthly est.] |
| [Competitor C] | [Count] | [Count] | [Count] | [Monthly est.] |
| **You** | [Count] | [Count] | [Count] | [Monthly est.] |

#### Step 3: Calculate Keyword Overlap

Identify four keyword segments:

```
┌──────────────────────────────────────────────────────────┐
│                                                          │
│  A: Keywords ONLY you rank for (your unique advantage)   │
│                                                          │
│  B: Keywords you AND competitors share (competitive)     │
│                                                          │
│  C: Keywords ONLY competitors rank for (your gaps)       │
│                                                          │
│  D: Keywords NO ONE ranks for (market opportunity)       │
│                                                          │
└──────────────────────────────────────────────────────────┘
```

| Segment | Size | Strategic Meaning | Action |
|---------|------|------------------|--------|
| A (Only you) | [Count] | Your content moat | Protect and strengthen |
| B (Shared) | [Count] | Competitive battleground | Improve rankings |
| C (Only them) | [Count] | Your content gaps | Prioritize and create |
| D (No one) | [Count] | Untapped market | Evaluate and pioneer |

#### Step 4: Filter and Categorize Gaps (Segment C)

Not all gaps are worth filling. Filter by:

| Filter | Threshold | Purpose |
|--------|-----------|---------|
| Minimum search volume | >100/month (adjust for niche) | Ensure traffic potential |
| Maximum keyword difficulty | <your domain's competitive range | Ensure you can rank |
| Business relevance | Must relate to your product/service | Ensure strategic fit |
| Intent match | Must match content types you can create | Ensure execution capability |

**After filtering, categorize remaining gaps:**

| Category | Description | Example |
|----------|-----------|---------|
| Topic gaps | Entire topics you haven't covered | Competitor has 10 articles on "technical SEO"; you have zero |
| Depth gaps | You cover the topic but competitor goes deeper | You have 1 blog post; competitor has a pillar page + 8 cluster articles |
| Angle gaps | Same topic but different perspective or audience | Competitor targets enterprise; you could target SMB |
| Format gaps | Same keyword but different content format | Competitor has a video tutorial; you only have text |
| Freshness gaps | Same topic but their content is more current | Competitor updated in 2026; yours is from 2024 |

#### Step 5: Prioritize Gaps

Use the scoring model from Section 4 below.

---

## 2. Content Format Gap Analysis

### Format Audit Methodology

#### Step 1: Inventory Your Content Formats

Categorize all your published content:

| Format | Count | % of Total | Avg. Traffic/Page | Top Performer |
|--------|-------|-----------|-------------------|--------------|
| Blog posts (text) | [X] | [X]% | [X] | [URL] |
| Long-form guides | [X] | [X]% | [X] | [URL] |
| How-to tutorials | [X] | [X]% | [X] | [URL] |
| Comparison/vs pages | [X] | [X]% | [X] | [URL] |
| Case studies | [X] | [X]% | [X] | [URL] |
| Templates/downloads | [X] | [X]% | [X] | [URL] |
| Interactive tools | [X] | [X]% | [X] | [URL] |
| Video content | [X] | [X]% | [X] | [URL] |
| Infographics | [X] | [X]% | [X] | [URL] |
| Original research/data | [X] | [X]% | [X] | [URL] |
| Glossary/definitions | [X] | [X]% | [X] | [URL] |
| Webinars/recordings | [X] | [X]% | [X] | [URL] |
| Podcasts/audio | [X] | [X]% | [X] | [URL] |

#### Step 2: Benchmark Against Competitors

| Format | You | Comp A | Comp B | Comp C | Industry Benchmark |
|--------|-----|--------|--------|--------|-------------------|
| Blog posts | [X] | [X] | [X] | [X] | Table stakes |
| Long-form guides | [X] | [X] | [X] | [X] | Expected for authority |
| How-to tutorials | [X] | [X] | [X] | [X] | Expected for SEO |
| Comparison pages | [X] | [X] | [X] | [X] | Required for commercial |
| Case studies | [X] | [X] | [X] | [X] | Expected for B2B |
| Templates | [X] | [X] | [X] | [X] | Lead gen standard |
| Interactive tools | [X] | [X] | [X] | [X] | Differentiator |
| Video | [X] | [X] | [X] | [X] | Growing expectation |
| Original research | [X] | [X] | [X] | [X] | Linkbait standard |
| Glossary | [X] | [X] | [X] | [X] | GEO opportunity |

#### Step 3: Identify Format Gaps

For each format you are missing or underrepresenting:

| Missing Format | Competitor Proof | Estimated Effort | Expected Impact | Priority |
|---------------|-----------------|-----------------|----------------|---------|
| [Format 1] | [Which competitor succeeds + traffic est.] | [Low/Med/High] | [Low/Med/High] | [P0-P3] |
| [Format 2] | [Evidence] | [Effort] | [Impact] | [Priority] |

#### Step 4: Format-SERP Feature Alignment

Certain formats unlock specific SERP features:

| Content Format | Unlocks SERP Feature | Schema Required |
|---------------|---------------------|----------------|
| FAQ sections | FAQ rich results, PAA eligibility | FAQPage |
| Step-by-step tutorials | How-To rich results, Featured Snippet (list) | HowTo |
| Review/comparison content | Review stars, AI Overview citations | Review, AggregateRating |
| Video content | Video carousel, Video rich result | VideoObject |
| Product pages | Shopping results, Product rich results | Product |
| Event pages | Event rich results | Event |
| Glossary/definitions | Featured Snippet (paragraph), AI Overview | DefinedTerm (optional) |
| Data tables | Featured Snippet (table), AI Overview | Table (optional) |

---

## 3. Funnel Stage Gap Identification

### Funnel Coverage Mapping

#### Step 1: Define Funnel Stages and Content Expectations

| Funnel Stage | User Mindset | Content Need | Expected Formats | Typical Keywords |
|-------------|-------------|-------------|-----------------|-----------------|
| **Awareness** | "I have a problem/question" | Educational content | Blog posts, infographics, social content | "what is", "how to", "why does" |
| **Interest** | "I want to learn more" | Deeper educational content | Guides, webinars, email courses | "guide to", "tutorial", "examples" |
| **Consideration** | "What are my options?" | Comparison and evaluation | Comparison posts, reviews, case studies | "best", "vs", "review", "alternatives" |
| **Intent** | "I'm narrowing my choices" | Decision-support content | Demos, free trials, pricing pages, ROI calculators | "pricing", "demo", "free trial" |
| **Purchase** | "I'm ready to act" | Conversion content | Product pages, checkout, signup forms | "buy", "sign up", "get started" |
| **Retention** | "I need help/value" | Support and engagement | Help docs, tutorials, community, newsletters | "[product] how to", "support" |
| **Advocacy** | "I want to share/recommend" | Shareable and referral content | Case studies, review programs, referral incentives | "[product] review", "recommend" |

#### Step 2: Audit Content by Funnel Stage

For each stage, count your content and compare to competitors:

| Funnel Stage | Your Content Count | Comp A | Comp B | Gap Size | Gap Severity |
|-------------|-------------------|--------|--------|----------|-------------|
| Awareness | [X] | [X] | [X] | [+/- X] | [Low/Med/High/Critical] |
| Interest | [X] | [X] | [X] | [+/- X] | [Low/Med/High/Critical] |
| Consideration | [X] | [X] | [X] | [+/- X] | [Low/Med/High/Critical] |
| Intent | [X] | [X] | [X] | [+/- X] | [Low/Med/High/Critical] |
| Purchase | [X] | [X] | [X] | [+/- X] | [Low/Med/High/Critical] |
| Retention | [X] | [X] | [X] | [+/- X] | [Low/Med/High/Critical] |
| Advocacy | [X] | [X] | [X] | [+/- X] | [Low/Med/High/Critical] |

**Gap Severity Criteria:**

| Severity | Definition |
|----------|-----------|
| Critical | Zero content at this stage; users drop off here |
| High | Significantly less content than competitors; measurable conversion drop |
| Medium | Somewhat less content; competitors have advantage but you are present |
| Low | Roughly on par; minor opportunities for improvement |

#### Step 3: Identify Drop-Off Points

Map your analytics data to funnel stages to find where users leave:

| Transition | Metric to Check | Drop-Off Signal | Content Gap Likely |
|-----------|----------------|----------------|-------------------|
| Awareness → Interest | Bounce rate on blog posts | >70% bounce rate | Missing "next step" content or CTAs |
| Interest → Consideration | Pages per session | <2 pages/session | Missing comparison/evaluation content |
| Consideration → Intent | Demo/trial requests | Low conversion from comparison pages | Missing trust content (case studies, reviews) |
| Intent → Purchase | Cart/signup abandonment | High abandonment rate | Missing objection-handling content |
| Purchase → Retention | Churn rate | High early churn | Missing onboarding/help content |

---

## 4. Opportunity Scoring Model

### Multi-Factor Gap Scoring

Score each identified gap on 5 factors (1-5 scale each):

| Factor | Weight | Score 1 (Low) | Score 3 (Medium) | Score 5 (High) |
|--------|--------|--------------|-----------------|----------------|
| **Search Demand** | 25% | <100 monthly searches | 500-2,000 searches | >5,000 searches |
| **Competitive Density** | 20% | All competitors cover it well | 1-2 competitors cover it | No competitor covers it |
| **Business Relevance** | 25% | Tangential to your offering | Related to your offering | Core to your offering |
| **Creation Effort** | 15% | Requires new capabilities | Moderate effort | Quick to create |
| **Conversion Potential** | 15% | Pure awareness (top-funnel) | Consideration stage | Decision/transactional stage |

**Gap Priority Score** = Σ (Factor Weight x Score)

### Priority Tiers

| Tier | Score Range | Timeline | Action |
|------|-----------|----------|--------|
| **P0 -- Fill Immediately** | 4.0-5.0 | This sprint / this week | High demand + low competition + high relevance |
| **P1 -- Fill This Quarter** | 3.0-3.9 | Next 1-3 months | Good demand + some competition + relevant |
| **P2 -- Plan for Future** | 2.0-2.9 | Next 3-6 months | Moderate opportunity, requires more resources |
| **P3 -- Monitor** | 1.0-1.9 | Track quarterly | Low priority but may become relevant |

### Quick-Win Identification

A "quick win" gap scores high on Demand + Relevance and low on Effort + Competition:

```
Quick Win Score = (Search Demand + Business Relevance) - (Creation Effort + Competitive Density)
                   Higher is better
```

| Quick Win Score | Assessment |
|----------------|-----------|
| 4+ | Strong quick win -- create this content first |
| 2-3 | Moderate quick win -- include in next content sprint |
| 0-1 | Not a quick win -- may still be strategically important |
| Negative | Avoid -- high effort/competition relative to demand |

---

## 5. Content Calendar Integration

### Gap-to-Calendar Workflow

#### Step 1: Group Gaps by Topic Cluster

Group related gaps into clusters rather than addressing them individually:

| Cluster | Related Gaps | Combined Volume | Pillar Needed? | Cluster Pages Needed |
|---------|-------------|----------------|---------------|---------------------|
| [Cluster A] | Gap 1, Gap 3, Gap 7 | [Sum of volumes] | [Yes/No] | [Count] |
| [Cluster B] | Gap 2, Gap 5 | [Sum of volumes] | [Yes/No] | [Count] |
| [Cluster C] | Gap 4, Gap 6, Gap 8, Gap 9 | [Sum of volumes] | [Yes/No] | [Count] |

#### Step 2: Sequence by Priority and Dependencies

| Order | Content Piece | Gap(s) Addressed | Priority | Dependencies | Target Publish |
|-------|-------------|-----------------|---------|-------------|---------------|
| 1 | [Pillar page for Cluster A] | Gap 1, 3, 7 (overview) | P0 | None | Week 1 |
| 2 | [Quick-win article] | Gap 2 | P0 | None | Week 2 |
| 3 | [Cluster A subtopic 1] | Gap 3 (deep dive) | P0 | Pillar published | Week 3 |
| 4 | [Cluster A subtopic 2] | Gap 7 (deep dive) | P1 | Pillar published | Week 4 |
| 5 | [Comparison page] | Gap 5 | P1 | None | Week 5 |

#### Step 3: Assign Resources and Track

| Content Piece | Writer | Reviewer | Target Date | Status | Gap Closed? |
|-------------|--------|---------|------------|--------|------------|
| [Title] | [Name] | [Name] | [Date] | [Draft/Review/Published] | [Yes/No/Partial] |

### Calendar Cadence by Team Size

| Team Size | Monthly Output | Gap Fill Rate | Full Gap Close Timeline |
|-----------|---------------|--------------|----------------------|
| Solo | 4-6 pieces/month | 3-4 gaps/month | 6-12 months for 30 gaps |
| Small (2-3) | 8-15 pieces/month | 6-10 gaps/month | 3-6 months for 30 gaps |
| Medium (4-6) | 15-25 pieces/month | 10-20 gaps/month | 2-3 months for 30 gaps |
| Large (7+) | 25+ pieces/month | 20+ gaps/month | 1-2 months for 30 gaps |

### Post-Publication Gap Validation

After publishing gap-filling content, validate that the gap is actually closed:

| Checkpoint | Timeframe | What to Check | Success Criteria |
|-----------|-----------|--------------|-----------------|
| Indexing | 1-2 weeks | Is the page indexed? | Appears in Google index |
| Initial ranking | 2-4 weeks | Is it ranking for target keyword? | Appears in top 100 |
| Competitive ranking | 2-3 months | Has it reached competitive positions? | Top 20 or improving trend |
| Traffic impact | 3-6 months | Is it driving meaningful traffic? | Meeting traffic projections |
| Gap closure | 6 months | Has the gap been effectively closed? | Ranking comparable to competitors |

---

## Framework Selection Guide

| Situation | Primary Framework | Secondary Framework |
|-----------|------------------|-------------------|
| "We need more traffic" | Keyword Gap Methodology | Content Calendar Integration |
| "Competitors outrank us everywhere" | Keyword Gap + Format Gap | Opportunity Scoring |
| "Our conversion rate is low" | Funnel Stage Gap | Format Gap (decision-stage formats) |
| "We don't know what to write next" | All three gap types | Opportunity Scoring + Calendar |
| "We have limited resources" | Opportunity Scoring (quick wins) | Keyword Gap (filtered by difficulty) |
| "We're entering a new market" | Keyword Gap (comprehensive) | Format Gap + Funnel Gap |
