# Keyword Intent Taxonomy

A comprehensive classification system for understanding search intent, mapping keywords to content strategies, and aligning with conversion funnels.

## Overview

Search intent (also called user intent or query intent) is the underlying goal a user has when typing a query into a search engine or AI system. Correctly classifying intent determines content format, tone, depth, and conversion strategy.

This taxonomy defines **4 primary intent types**, each with **3-4 sub-categories**, along with signal words, SERP feature correlations, and content format recommendations.

---

## Primary Intent Types

### 1. Informational Intent

The user wants to **learn something**. They are seeking knowledge, not a product.

#### Sub-categories

| Sub-category | Description | Example Queries |
|-------------|------------|----------------|
| **Educational** | Broad learning about a topic | "what is SEO", "content marketing explained", "how search engines work" |
| **Instructional** | Step-by-step guidance on completing a task | "how to set up Google Analytics", "how to write a meta description", "how to do keyword research" |
| **Exploratory** | Open-ended research to understand options | "types of SEO strategies", "content marketing trends", "link building techniques" |
| **Troubleshooting** | Diagnosing and fixing a problem | "why is my site not ranking", "Google indexing issues", "404 error fix" |

#### Signal Words and Modifiers

**Strong informational signals:**
- what, what is, what are, what does
- how, how to, how does, how do I
- why, why is, why does, why do
- when, when to, when should
- who, who is, who does
- where, where to, where can I
- guide, tutorial, learn, explain
- examples, tips, ideas, ways
- definition, meaning, difference between
- history of, basics of, introduction to
- pros and cons, advantages, disadvantages
- best practices, checklist, steps

**Weak informational signals (may overlap with commercial):**
- overview, comparison, review (can be commercial)
- list of, types of, methods

#### SERP Feature Correlation

| SERP Feature | Frequency for Informational | Notes |
|-------------|---------------------------|-------|
| Featured Snippet | Very High | Especially for "what is" and "how to" queries |
| People Also Ask | Very High | Almost always present for informational queries |
| Knowledge Panel | High | For entity-related informational queries |
| AI Overview | Very High | AI systems prioritize informational answers |
| Video Carousel | Medium-High | Especially for instructional queries |
| Image Pack | Medium | For visual/diagram-seeking queries |
| Shopping Results | Very Low | Rarely appears for pure informational |

#### Content Format Recommendations

| Sub-category | Best Formats | Target Length | Key Elements |
|-------------|-------------|--------------|-------------|
| Educational | Definitive guides, explainers, glossary entries | 1,500-3,000 words | Clear definitions, examples, visuals |
| Instructional | Step-by-step tutorials, how-to guides, video walkthroughs | 2,000-4,000 words | Numbered steps, screenshots, code samples |
| Exploratory | Listicles, roundups, trend reports, comparison tables | 2,000-3,500 words | Categories, pros/cons, use cases |
| Troubleshooting | FAQ pages, debug guides, knowledge base articles | 800-2,000 words | Problem-solution pairs, error codes, screenshots |

---

### 2. Navigational Intent

The user wants to **find a specific website, page, or resource**. They already know where they want to go.

#### Sub-categories

| Sub-category | Description | Example Queries |
|-------------|------------|----------------|
| **Brand Search** | Looking for a specific company or product | "Ahrefs", "HubSpot CRM", "Moz Pro" |
| **Product/Feature Search** | Looking for a specific feature or tool within a known brand | "Ahrefs keyword explorer", "Google Search Console coverage report" |
| **Login/Access** | Trying to access an account or dashboard | "Ahrefs login", "Google Analytics sign in", "SEMrush dashboard" |
| **Support/Docs** | Seeking help documentation for a known product | "Ahrefs API documentation", "Google Search Console help" |

#### Signal Words and Modifiers

**Strong navigational signals:**
- [brand name] (standalone)
- [brand name] login, sign in, sign up
- [brand name] pricing, plans
- [brand name] support, help, docs
- [brand name] [feature name]
- [brand name] download, app
- official, website, site
- [brand name] alternatives (borderline commercial)

#### SERP Feature Correlation

| SERP Feature | Frequency for Navigational | Notes |
|-------------|---------------------------|-------|
| Sitelinks | Very High | Brand queries almost always show sitelinks |
| Knowledge Panel | High | For established brands with Google entity |
| Featured Snippet | Low | Rarely for pure navigational |
| People Also Ask | Medium | Often brand-related questions |
| AI Overview | Low | AI usually defers to direct navigation |

#### Content Format Recommendations

| Sub-category | Best Formats | Key Elements |
|-------------|-------------|-------------|
| Brand Search | Homepage, about page, landing pages | Clear branding, value prop, navigation |
| Product/Feature Search | Product pages, feature pages | Feature details, CTAs, screenshots |
| Login/Access | Login page, getting started guide | Fast load, clear login form, password reset |
| Support/Docs | Knowledge base, documentation hub | Search functionality, categorized articles |

---

### 3. Commercial Investigation Intent

The user is **researching before making a purchase decision**. They are comparing options, reading reviews, and evaluating alternatives.

#### Sub-categories

| Sub-category | Description | Example Queries |
|-------------|------------|----------------|
| **Comparison** | Evaluating two or more specific options | "Ahrefs vs SEMrush", "WordPress vs Squarespace for SEO" |
| **Review-seeking** | Looking for opinions and evaluations | "Ahrefs review 2026", "best SEO tool reviews", "is Moz worth it" |
| **Best-of Research** | Seeking curated top options in a category | "best SEO tools", "top keyword research tools", "best free backlink checkers" |
| **Evaluation** | Assessing fit for a specific need | "SEO tools for small business", "enterprise SEO platform features", "SEO tool for agencies" |

#### Signal Words and Modifiers

**Strong commercial signals:**
- best, top, leading
- vs, versus, compared to, comparison
- review, reviews, rating, ratings
- alternative, alternatives to
- like [brand], similar to
- for [audience], for [use case]
- pros and cons (when about products)
- worth it, is [product] good
- features, capabilities, integrations
- pricing, cost, how much
- free vs paid, premium

**Seasonal/temporal commercial signals:**
- [product] [year] (e.g., "best SEO tools 2026")
- new, latest, updated

#### SERP Feature Correlation

| SERP Feature | Frequency for Commercial | Notes |
|-------------|------------------------|-------|
| People Also Ask | Very High | Comparison and evaluation questions |
| Featured Snippet | High | Especially for "best" and comparison queries |
| AI Overview | High | AI often synthesizes comparisons |
| Shopping Results | Medium | When products have direct purchase path |
| Video Carousel | Medium | Review and comparison videos |
| Ads (top) | Very High | Advertisers target commercial intent heavily |

#### Content Format Recommendations

| Sub-category | Best Formats | Target Length | Key Elements |
|-------------|-------------|--------------|-------------|
| Comparison | Side-by-side comparison pages, "X vs Y" articles | 2,500-4,000 words | Feature tables, pricing tables, verdict |
| Review-seeking | In-depth reviews, user testimonials, case studies | 2,000-3,500 words | Honest pros/cons, screenshots, scoring |
| Best-of Research | Ranked listicles, category roundups | 3,000-5,000 words | Criteria explanation, mini-reviews, comparison table |
| Evaluation | Buying guides, use-case guides, ROI calculators | 2,000-3,500 words | Decision criteria, audience segmentation, recommendations |

---

### 4. Transactional Intent

The user wants to **complete a specific action**, typically a purchase, signup, or download.

#### Sub-categories

| Sub-category | Description | Example Queries |
|-------------|------------|----------------|
| **Purchase** | Ready to buy a product or service | "buy Ahrefs subscription", "SEMrush pricing plans", "order SEO audit" |
| **Signup/Trial** | Ready to create an account or start a trial | "Ahrefs free trial", "sign up for Moz", "create Google Search Console account" |
| **Download** | Wants to download software, template, or resource | "download Screaming Frog", "SEO checklist PDF download", "free keyword template" |
| **Hire/Engage** | Ready to hire a professional or agency | "hire SEO consultant", "SEO agency near me", "freelance SEO expert" |

#### Signal Words and Modifiers

**Strong transactional signals:**
- buy, purchase, order, subscribe
- price, pricing, cost, discount, coupon, deal
- free trial, demo, signup, sign up, register
- download, install, get
- hire, book, schedule, request quote
- near me, in [location]
- cheap, affordable, budget
- premium, pro, enterprise
- [product] discount code, [product] coupon

#### SERP Feature Correlation

| SERP Feature | Frequency for Transactional | Notes |
|-------------|---------------------------|-------|
| Shopping Results | Very High | Dominant for product purchase queries |
| Ads (top + bottom) | Very High | Maximum ad coverage |
| Local Pack | High | For service-based transactional queries |
| Sitelinks | Medium | For brand-specific transactional |
| Featured Snippet | Low | Rarely for pure transactional |
| AI Overview | Low-Medium | Sometimes for pricing/comparison |

#### Content Format Recommendations

| Sub-category | Best Formats | Key Elements |
|-------------|-------------|-------------|
| Purchase | Product pages, pricing pages, checkout | Clear pricing, CTAs, trust signals, reviews |
| Signup/Trial | Landing pages, signup forms, onboarding | Minimal friction, benefits, social proof |
| Download | Resource landing pages, gated content | Preview, form, instant delivery |
| Hire/Engage | Service pages, contact forms, portfolios | Credentials, case studies, clear next step |

---

## Intent Mapping to Conversion Funnel

### Full Funnel Alignment

```
FUNNEL STAGE        INTENT TYPE              CONTENT GOAL
─────────────────────────────────────────────────────────────
Awareness       →   Informational            Attract & educate
                    (Educational, Exploratory)

Interest        →   Informational            Deepen engagement
                    (Instructional)

Consideration   →   Commercial Investigation  Build preference
                    (Best-of, Comparison)

Evaluation      →   Commercial Investigation  Overcome objections
                    (Review, Evaluation)

Decision        →   Transactional            Convert
                    (Purchase, Signup, Hire)

Retention       →   Navigational             Support & retain
                    (Support/Docs, Login)

Advocacy        →   Informational            Enable sharing
                    (Educational — about you)
```

### Conversion Potential by Intent

| Intent Type | Avg. Conversion Rate | Typical CTA | Nurture Length |
|------------|---------------------|-------------|---------------|
| Informational | 0.5-2% | Newsletter signup, content download | Long (weeks-months) |
| Navigational | N/A (already engaged) | Login, access feature | N/A |
| Commercial Investigation | 2-5% | Free trial, demo request, comparison download | Medium (days-weeks) |
| Transactional | 5-15% | Buy now, subscribe, hire | Short (immediate-days) |

---

## Mixed Intent Queries

Many real-world queries blend multiple intent types. Recognize and address the dominant + secondary intent.

### Common Mixed Intent Patterns

| Query Pattern | Primary Intent | Secondary Intent | Content Strategy |
|--------------|---------------|-----------------|-----------------|
| "best [product] for [use case]" | Commercial | Informational | Buying guide with educational context |
| "how to [task] with [product]" | Instructional | Navigational | Tutorial featuring the product |
| "[product] review and pricing" | Commercial | Transactional | Review with clear pricing CTAs |
| "what is [concept] tools" | Informational | Commercial | Explainer that transitions to tool recommendations |
| "[product] free download" | Transactional | Navigational | Landing page with download + product info |

### Handling Mixed Intent in Content

1. **Lead with the primary intent** -- answer the dominant question first
2. **Bridge to the secondary intent** -- naturally transition to the secondary need
3. **Match SERP format** -- if SERPs show mixed results, your content should too
4. **Segment CTAs** -- provide different CTAs for different intent segments within the page

---

## SEO-Specific Keyword Intent Examples

### SEO Industry Keyword Classification

| Keyword | Intent | Sub-category | Recommended Content |
|---------|--------|-------------|-------------------|
| what is SEO | Informational | Educational | Definitive guide with visuals |
| how to do keyword research | Informational | Instructional | Step-by-step tutorial |
| best SEO tools 2026 | Commercial | Best-of Research | Ranked listicle with mini-reviews |
| Ahrefs vs SEMrush | Commercial | Comparison | Side-by-side feature comparison |
| buy Ahrefs subscription | Transactional | Purchase | Pricing/product page |
| Google Search Console login | Navigational | Login/Access | Login page or redirect |
| why is my site not indexing | Informational | Troubleshooting | Debug guide with solutions |
| SEO agency for ecommerce | Transactional | Hire/Engage | Service page with portfolio |
| is Moz worth it | Commercial | Review-seeking | Honest review with alternatives |
| SEO checklist template | Transactional | Download | Gated resource landing page |
| types of backlinks | Informational | Exploratory | Categorized explainer |
| SEMrush pricing | Commercial | Evaluation | Pricing breakdown page |

---

## Applying Intent Taxonomy in Keyword Research

### Step-by-Step Classification Process

1. **Read the query literally** -- what is the user asking for?
2. **Check for signal words** -- match against the signal word tables above
3. **Verify against SERP** -- what does Google actually show? The SERP is the ground truth
4. **Identify sub-category** -- narrow from primary intent to sub-category
5. **Check for mixed intent** -- does the query blend two types?
6. **Map to content format** -- select format based on intent + sub-category
7. **Assign funnel stage** -- determine where this fits in the buyer journey
8. **Set conversion expectation** -- align CTA and goals with intent type

### Common Classification Mistakes

| Mistake | Example | Why It's Wrong | Correct Classification |
|---------|---------|---------------|----------------------|
| Treating all "best" queries as informational | "best CRM software" | User is comparing products to buy | Commercial Investigation |
| Treating all questions as informational | "how much does Ahrefs cost" | User is evaluating a purchase | Commercial / Transactional |
| Ignoring local intent | "SEO services" | May have strong local intent in many contexts | Transactional (local) |
| Missing navigational intent | "HubSpot blog" | User wants a specific page | Navigational |
| Assuming single intent | "SEO tools" | Could be informational OR commercial | Mixed -- check SERP |
