---
name: setup-payoff-ledger
description: Maintain a structured Setup/Payoff ledger (promises, debts, payoffs) and generate a payoff roadmap.
---

## When to use
- Building or updating the “伏笔台账”
- Author edits cause deviations and you need to check whether setups were broken or payoffs drifted.

## Output files (human-readable)
- `artifacts/ledger/setup_payoff_ledger.md`: **SSOT** structured ledger entries (author editable)
- `artifacts/ledger/reports/<run_id>_setup_payoff_report.md`: derived scan report (auto-generated)

## Entry schema (v1 deterministic JSON block)
`setup_payoff_ledger.md` must contain a ` ```json ` code block like:

```json
{
  "entries": [
    {
      "id": "promise-a",
      "type": "promise",
      "title": "A promises to reveal X",
      "setupPattern": "I will tell you X",
      "payoffPattern": "X is revealed",
      "deadlineChapter": 12,
      "regex": false,
      "severity": "MAJOR"
    }
  ]
}
```

Fields (recommended):
- **id**: stable id (unique)
- **type**: setup / promise / debt (free-form for now)
- **title**: one-line human title
- **setupPattern**: keyword or regex to locate the setup
- **payoffPattern**: keyword or regex to locate the payoff
- **deadlineChapter**: optional “should be paid by chapter N”
- **regex**: true to treat patterns as regex
- **severity**: MINOR / MAJOR (free-form for now)

## Heuristics (assistant mindset)
- A setup is “broken” if later text contradicts its promise without an intentional twist.
- A payoff is “weak” if it resolves mechanically without emotional/meaningful consequence.
- “Upgradable” setups are those with high emotional stakes but low information cost.

## Procedure
1) Scan story outline + existing chapters for explicit promises and implicit debts.
2) Normalize them into ledger entries (avoid duplicates).
3) Mark conflicts introduced by author deviations.
4) Generate 2-3 payoff roadmaps:
   - conservative (minimal edits)
   - aggressive (rewrite/upgrade to a bigger twist)
   - branch option (if it risks breaking the mainline)


