# Character Development Reference

This reference provides frameworks for creating compelling, multi-dimensional characters.

## Core Character Elements

### Basic Profile
- **Name**: Full name, nicknames, name meaning
- **Age**: Chronological and how they present
- **Physical Description**: Distinguishing features, style, mannerisms
- **Role**: Protagonist, antagonist, supporting, mentor, etc.
- **Archetype**: Hero, mentor, trickster, everyman, etc.

### Personality Dimensions
- **Temperament**: Sanguine, choleric, melancholic, phlegmatic
- **Traits**: 3-5 defining characteristics (both positive and negative)
- **Quirks**: Unique habits or behaviors
- **Speech Patterns**: How they talk, vocabulary, accent
- **Sense of Humor**: Type and style

### Motivation & Goals
- **External Goal**: What they're trying to achieve (plot-level)
- **Internal Goal**: What they're trying to become (character arc)
- **Motivation**: Why they want these things
- **Stakes**: What happens if they fail
- **Misbelief/Lie**: False belief holding them back

## Character Backstory Framework

### The Ghost (Past Wound)
- **Traumatic Event**: What happened in their past
- **Age When It Occurred**: How it shaped their development
- **Who Was Involved**: Other characters connected to trauma
- **How It Changed Them**: Before and after personality
- **Coping Mechanisms**: How they deal with the wound

### Formative Relationships
- **Family Dynamics**: Parents, siblings, family structure
- **Key Friendships**: Influences from peers
- **Romantic History**: Past relationships and their impact
- **Mentors/Role Models**: Who shaped their values
- **Enemies/Rivals**: Antagonistic relationships that defined them

### Life History
- **Childhood**: Key events, family situation, early personality
- **Adolescence**: Identity formation, major choices, first loves/losses
- **Young Adulthood**: Independence, career/path choices, relationships
- **Current Situation**: Where story finds them

## Character Arc Types

### Positive Change Arc
**Structure:**
1. Lie they believe
2. Want vs. Need established
3. First glimpse of truth
4. Rejection of truth (return to lie)
5. Moment of truth (crisis)
6. Choice to embrace truth
7. New worldview demonstrated

**Markers:**
- Start: Incomplete, held back by misbelief
- Midpoint: Glimpse growth but not ready
- Climax: Must choose between lie and truth
- End: Transformed, living truth

### Flat Arc
**Structure:**
1. Truth known from beginning
2. World believes lie
3. Character tested on their truth
4. Character demonstrates truth
5. World begins to change
6. Truth proven through action

**Markers:**
- Start: Strong in beliefs
- Midpoint: Severely tested
- Climax: Greatest test of faith
- End: Changed the world, not themselves

### Negative Arc
**Structure:**
1. Flaw/weakness established
2. Temptation introduced
3. Small compromises begin
4. Point of no return crossed
5. Descent accelerates
6. Rejection of redemption
7. Tragic conclusion

**Markers:**
- Start: Flawed but sympathetic
- Midpoint: Questionable choices
- Climax: Beyond redemption
- End: Destroyed or becomes villain

## Relationship Dynamics

### Character Relationships Matrix
For each significant relationship, define:
- **Dynamic Type**: Mentor/student, rivals, allies, romance, family
- **Conflict Source**: What creates tension
- **Common Ground**: What bonds them
- **Influence**: How they change each other
- **Arc**: How relationship evolves

### Protagonist-Antagonist Relationship
- **Opposition**: How antagonist blocks protagonist's goal
- **Mirror/Foil**: How they reflect/contrast each other
- **Personal Stakes**: Why this matters beyond plot
- **Symmetry**: Similar origins or opposite arc paths
- **Respect Level**: Do they understand each other?

## Character Voice Development

### Dialogue Markers
- **Vocabulary Level**: Formal, casual, slang, technical
- **Sentence Structure**: Short and punchy vs. long and flowing
- **Favorite Words/Phrases**: Repeated expressions
- **Topics They Discuss**: What they talk about most
- **What They Avoid**: Topics they don't address
- **Lying Tells**: How they behave when dishonest

### Internal Voice (POV Characters)
- **Thought Patterns**: Analytical, emotional, scattered, focused
- **Biases**: How they interpret events
- **Blind Spots**: What they don't see about themselves
- **Metaphors**: Types of comparisons they make
- **Narrative Distance**: Close, intimate vs. distant, observational

## Character Consistency

### Behavioral Patterns
- **Under Stress**: How they react to pressure
- **When Happy**: How they express joy
- **When Angry**: Explosive, cold, passive-aggressive
- **Decision-Making**: Impulsive, analytical, avoidant
- **Trust**: Quick or slow to trust others

### Core Values
- **Non-Negotiables**: Lines they won't cross
- **Flexible Areas**: Where they compromise
- **Value Hierarchy**: Ranking of priorities (family, honor, survival, etc.)
- **Values Testing**: Scenes where values conflict

### Growth Indicators
- **Early Story**: How they handle situation type X
- **Mid Story**: How handling of X begins to shift
- **Late Story**: How they handle X after growth
- **Demonstration**: Parallel scenes showing change

## Character Roles in Ensemble

### Ensemble Balance
- **The Leader**: Drives action, makes decisions
- **The Heart**: Emotional center, unifies group
- **The Brain**: Strategy, knowledge, analysis
- **The Warrior**: Action, protection, physical strength
- **The Wildcard**: Unpredictable, challenges norms
- **The Conscience**: Moral compass, voice of reason

### Avoiding Character Redundancy
- **Different Wants**: Each character pursuing different goals
- **Different Methods**: Varied approaches to problems
- **Different Worldviews**: Contrasting perspectives
- **Different Skills**: Complementary abilities
- **Different Arcs**: Each on unique journey

## Character Development Questions

### Surface Level
- What do they look like?
- How do they dress?
- What's their job/role?
- Where do they live?

### Deeper Level
- What do they fear most?
- What do they desire more than anything?
- What's their greatest secret?
- What do they lie to themselves about?
- What would they sacrifice everything for?

### Behavioral Level
- How do they treat people with less power?
- What makes them laugh?
- What makes them cry?
- When do they lie, and why?
- How do they handle failure?

### Thematic Level
- What do they represent in the story?
- What question does their arc answer?
- How do they embody or challenge the theme?
- What truth do they discover?

## Character Testing Scenarios

To ensure character depth, test them against:

1. **Moral Dilemma**: Force choice between two values
2. **Loss**: Take away something they depend on
3. **Temptation**: Offer something they want vs. need
4. **Betrayal**: Test their trust and forgiveness
5. **Sacrifice**: Force them to give up something important
6. **Revelation**: Expose a truth they've been avoiding
7. **Isolation**: Remove their support system
8. **Power**: Give them control and see how they use it

## Red Flags for Weak Characters

### Avoid:
- **Mary Sue/Gary Stu**: Too perfect, no real flaws
- **Inconsistent Behavior**: Acts differently for plot convenience
- **No Agency**: Things happen to them, they don't drive action
- **Single-Note**: Only one personality trait
- **No Growth**: Same at end as beginning (unless flat arc)
- **Reactive Only**: Never makes proactive choices
- **Exposition Puppet**: Exists to explain things
- **Token Diversity**: Defined only by identity marker

### Fix By:
- Adding meaningful flaws and consequences
- Establishing behavioral patterns and motivations
- Giving them goals and plans they actively pursue
- Layering contradictory traits and complexity
- Planning clear arc with transformation
- Creating scenes where they initiate action
- Giving them purpose beyond information delivery
- Developing full personality, backstory, and individual arc
