---
name: information-architecture
description: >
  Organize and structure information for clarity and discoverability. Design
  navigation systems, hierarchies, and mental models that match user needs.
---

# Information Architecture

## Table of Contents

- [Overview](#overview)
- [When to Use](#when-to-use)
- [Quick Start](#quick-start)
- [Reference Guides](#reference-guides)
- [Best Practices](#best-practices)

## Overview

Information Architecture creates logical structures that help users find and understand information easily.

## When to Use

- Website or app redesign
- Large information spaces (documentation, e-commerce)
- Navigation structure planning
- Taxonomy and categorization
- Search functionality design
- User journey mapping

## Quick Start

Minimal working example:

```yaml
IA Process:

1. Research & Discovery
  - Interview users about mental models
  - Card sorting sessions (open and closed)
  - Analyze current usage patterns
  - Competitive analysis

2. Structure Development
  - Create organization scheme (hierarchical, faceted, etc.)
  - Define categories and relationships
  - Build taxonomy
  - Plan navigation

3. Wireframing
  - Sitemap creation
  - Navigation structure
  - Page templates
  - User flows

4. Validation
  - User testing with prototypes
  - Tree testing (navigation only)
  - Iterate based on feedback

// ... (see reference guides for full implementation)
```

## Reference Guides

Detailed implementations in the `references/` directory:

| Guide | Contents |
|---|---|
| [Card Sorting & Taxonomy](references/card-sorting-taxonomy.md) | Card Sorting & Taxonomy |
| [Sitemap & Navigation Structure](references/sitemap-navigation-structure.md) | Sitemap & Navigation Structure |
| [Search & Discovery](references/search-discovery.md) | Search & Discovery |

## Best Practices

### ✅ DO

- Start with user research
- Conduct card sorting studies
- Use user mental models
- Keep hierarchy 3 levels deep max
- Use clear, simple labels
- Enable multiple ways to find content
- Test navigation with users
- Update based on usage data
- Document taxonomy
- Provide search functionality

### ❌ DON'T

- Impose organizational structure without research
- Use jargon or technical terms
- Make hierarchy too deep
- Bury important content
- Rely only on navigation (provide search)
- Change navigation frequently
- Create ambiguous labels
- Forget about edge cases
- Ignore accessibility
- Assume desktop-only navigation
