# Biz-Ops Workspace

Microsoft workIQ をベースとした業務管理ワークスペース。

> 📊 **毎日見る**: [DASHBOARD.md](DASHBOARD.md) ← 今日やること・直近予定

## 概要

| 機能             | 説明                                  |
| ---------------- | ------------------------------------- |
| 業務棚卸         | 業務内容の可視化・時間配分分析        |
| レポート生成     | デイリー/週次/月次レポートの自動生成  |
| タスク管理       | タスクの作成・追跡・完了管理          |
| データ収集       | Teams/メール/Excel等からの情報収集    |
| 顧客自動振り分け | 顧客名検出→顧客フォルダに自動振り分け |
| 社内行事振り分け | Tech Connect/1on1等を自動分類         |
| 上司PR           | 活動報告・成果アピール資料作成        |

## エージェント構成

| エージェント     | 役割                                   |
| ---------------- | -------------------------------------- |
| orchestrator     | 統括・タスク振り分け                   |
| report-generator | レポート自動生成（レビューループ付き） |
| report-reviewer  | 成果志向レポートレビュー（IMPACT評価） |
| task-manager     | タスク管理                             |
| data-collector   | データ収集・顧客/社内自動振り分け      |
| work-inventory   | 業務棚卸・分析                         |

## ディレクトリ構成

```
{workspace}/
├── DASHBOARD.md          # 毎日見るハブ
├── AGENTS.md             # ワークスペース説明
├── ActivityReport/       # 業務レポート（上司PR・評価面談用）
├── Customers/            # 顧客別ワークスペース
├── Tasks/                # タスク管理
├── _internal/            # 社内行事・内部イベント
├── _inbox/               # 情報蓄積（未分類ログ）
├── _datasources/         # データソース設定
├── _workiq/              # workIQ コア設定
└── .github/              # エージェント・プロンプト
```

## 顧客ワークスペース

<!-- 顧客リストをセットアップ時に追加 -->

| 顧客ID | 顧客名 | フォルダ |
| ------ | ------ | -------- |

## クイックスタート

```
# レポート生成
「デイリーレポートを作成」

# タスク追加
「タスク追加: 〇〇の資料作成」

# データ収集（自動振り分け）
[Teams チャットをペースト] → 顧客検出 → 顧客フォルダへ

# 業務棚卸
「今月の業務を棚卸」
```
