# {{BOOK_TITLE}} - Copilot Guide

## Overview

This is the book writing workspace for "{{BOOK_TITLE}}".

### Target Readers

- (Define your target audience here)

### Goals

- (Define what readers will learn)

## Folder Structure

| Folder                   | Purpose                 |
| ------------------------ | ----------------------- |
| `01_contents_keyPoints/` | Outlines and key points |
| `02_contents/`           | Final manuscripts       |
| `03_re-view_output/`     | Re:VIEW source and PDF  |
| `04_images/`             | Image assets            |
| `99_material/`           | Reference materials     |
| `docs/`                  | Project documentation   |
| `scripts/`               | Utility scripts         |

## Constraints

| Rule           | Reference                                                                                 |
| -------------- | ----------------------------------------------------------------------------------------- |
| Writing style  | [writing.instructions.md](instructions/writing/writing.instructions.md)                   |
| Heading levels | [writing-heading.instructions.md](instructions/writing/writing-heading.instructions.md)   |
| Notation       | [writing-notation.instructions.md](instructions/writing/writing-notation.instructions.md) |
| File naming    | [naming-conventions.md](../docs/naming-conventions.md)                                    |
| Agents         | [AGENTS.md](../AGENTS.md)                                                                 |

## Git Operations

- **Before work**: `git fetch origin` to sync
- **After work**: `git add`, `git commit` (Japanese, concise)
- **Push**: Only when explicitly instructed
- **Important**: Verify current directory before commands

## Quick Commands

| Prompt             | Action              |
| ------------------ | ------------------- |
| `/gc_Commit`       | Commit changes      |
| `/gcp_Commit_Push` | Commit and push     |
| `/gpull`           | Pull remote changes |
