---
applyTo: "02_contents/**/*.md"
---

# Writing Notation Instructions

Consistent notation and terminology rules.

## Numbers

| Type        | Rule           | Example     |
| ----------- | -------------- | ----------- |
| Quantities  | Half-width     | 100個、5章  |
| Years       | Half-width     | 2024年      |
| Percentages | Half-width + % | 80%、50%    |
| Ranges      | Half-width + ~ | 1~10、5~6章 |

## Punctuation

| Symbol        | Japanese | Usage               |
| ------------- | -------- | ------------------- |
| Period        | 。       | End of sentence     |
| Comma         | 、       | Clause separator    |
| Colon         | ：       | Full-width in prose |
| Parentheses   | （）     | Full-width in prose |
| Quotes        | 「」     | Terminology, titles |
| Double quotes | 『』     | Book titles         |

## Technical Terms

### First Occurrence

Format: 日本語（English）

Examples:

- 機密性（Confidentiality）
- 多層防御（Defense in Depth）
- データ損失防止（Data Loss Prevention、DLP）

### Subsequent Occurrences

Use Japanese only (or acronym if introduced):

- 機密性
- DLP

## Abbreviations

| Term | First Use                                                 | After |
| ---- | --------------------------------------------------------- | ----- |
| DLP  | データ損失防止（Data Loss Prevention、DLP）               | DLP   |
| API  | アプリケーション・プログラミング・インターフェース（API） | API   |

## Product Names

- Write exactly as official documentation
- Examples:
  - Microsoft Purview
  - Azure Active Directory
  - GitHub Copilot

## Consistency Checklist

- [ ] Numbers are half-width
- [ ] Punctuation follows rules
- [ ] Terms explained on first use
- [ ] Product names match official
- [ ] Acronyms introduced properly
