---
applyTo: "02_contents/**/*.md"
---

# Writing Instructions

Guidelines for manuscript writing style and quality.

## Style Rules

### Tone

- Use polite/desu-masu style (です・ます調)
- Write natural Japanese (avoid translation-style)
- Keep sentences under 500 characters
- Vary sentence length and endings for natural flow

### Terminology

- Explain technical terms on first use
- Format: Japanese (English) - e.g., 機密性（Confidentiality）
- Use consistent terminology throughout

### Structure

- Abstract → Concrete → Re-abstract
- "Why" → "What to protect" → "How to design"
- End with practical application, not just theory

## Introduction Pattern (5 Steps)

1. **Hook** - Question, surprise, or empathy
2. **Concrete scene** - Numbers, scenarios, failure examples
3. **Core learning** - Concepts, mechanisms
4. **Tomorrow's action** - Practical application
5. **Lingering thought** - One memorable line

## Summary Pattern

- Key point recap (1-3 bullets)
- Practical next step
- Lingering thought or question
- Bridge to next chapter

## Figures and Lists

| Element      | Rule                                                        |
| ------------ | ----------------------------------------------------------- |
| Bullet lists | Max 3 consecutive in a section, end with prose              |
| Tables       | Max 1 per section, column headers ≤6 chars, cells ≤20 chars |
| Figures      | For concept/flow only, numbered with captions               |
| Images       | Format: `![Image: Title](images/fig-X-X-XX.png)`            |

## Word Count Targets

See `docs/page-allocation.md` for detailed targets per file type.

## Forbidden Patterns

- Overuse of em-dashes (——) for dramatic effect
- Consecutive bullet lists without prose breaks
- Translation-style Japanese
- Sentences over 500 characters
