---
name: customer-workspace
description: Customer workspace initialization skill. Provides inbox (information accumulation), meeting minutes management, and auto-classification rules. Use for "setup customer workspace" or "add inbox feature" requests.
license: CC BY-NC-SA 4.0
metadata:
  author: yamapan (https://github.com/aktsmm)
---

# Customer Workspace Skill

Initialize customer-specific workspaces with information accumulation and meeting notes management.

## When to Use

- **Customer workspace**, **inbox**, **meeting notes**
- Setting up per-customer workspaces
- Adding inbox or meeting minutes management
- Implementing auto-classification rules for customer information

## Features

| Feature              | Description                                |
| -------------------- | ------------------------------------------ |
| **Inbox**            | Paste chat/email for auto-classification   |
| **Meeting Notes**    | Convert Teams AI notes to template format  |
| **Auto-Routing**     | Route input based on pattern detection     |
| **Customer Profile** | Centralized customer information           |

---

## Quick Start

```powershell
# Basic
.\scripts\Initialize-CustomerWorkspace.ps1 -CustomerName "Contoso Inc"

# Full options
.\scripts\Initialize-CustomerWorkspace.ps1 `
  -CustomerName "Contoso Inc" `
  -ContractType "MACC" `
  -ContractPeriod "2025/04 - 2028/03" `
  -KeyContacts "John Doe (Infra Lead)"
```

## Generated Structure

```
{workspace}/
├── .github/
│   ├── copilot-instructions.md    ← Auto-routing rules
│   └── prompts/                   ← Inbox, meeting notes
├── _inbox/{YYYY-MM}.md            ← Inbox files
├── _customer/profile.md           ← Customer profile
└── _templates/                    ← Templates
```

---

## Auto-Routing Patterns

| Pattern                      | Action            |
| ---------------------------- | ----------------- |
| "Generated by AI"            | → Meeting notes   |
| Name + datetime + short text | → Inbox           |
| Contains `From:` `Date:`     | → Inbox           |
| Bullet points / short memo   | → Inbox           |
| Question format              | → Normal response |

## Default Tags

`#network` `#cost` `#contract` `#proposal` `#ai` `#container` `#meeting` `#support` `#organization` `#deadline` `#internal`

---

## Done Criteria

- [ ] Workspace folder created
- [ ] `_inbox/{YYYY-MM}.md` exists
- [ ] `_customer/profile.md` configured
- [ ] Auto-routing rules working

## Key References

- [Inbox Rules](references/inbox-rules.md)
- [Meeting Minutes Rules](references/meeting-minutes-rules.md)

## Assets

- `assets/_templates/` - Template files
- `assets/inbox.prompt.md` - Inbox prompt
- `assets/convert-meeting-minutes.prompt.md` - Meeting notes prompt
- `assets/copilot-instructions.md` - Auto-routing rules
