---
description: 情報をインボックスに追記（チャット、メール、メモ等を自動分類）
---

# インボックス追記

顧客に関する情報を `_inbox/{YYYY-MM}.md` に蓄積する。

## 処理フロー

1. **形式判定**: Teams / メール / Slack / メモ を自動判別
2. **情報抽出**: 日時・送信者・ソースを抽出
3. **タグ推定**: キーワードからタグ付与（該当なしは新規タグ生成）
4. **追記**: 月別ファイルに正規化フォーマットで追記

## 形式判定

| 判定条件                       | 形式   |
| ------------------------------ | ------ |
| `From:` + `Date:` + `Subject:` | メール |
| 名前 + 改行 + 日時パターン     | Teams  |
| `[#channel]` パターン          | Slack  |
| `-` で始まる行が複数           | メモ   |

## 出力形式

```markdown
---

## {日時} {タグ}

**From**: {送信者}（{Source}）

{本文}
```

## デフォルトタグ

`#network` `#cost` `#contract` `#proposal` `#ai` `#container` `#meeting` `#support` `#organization` `#deadline` `#internal`

**該当なし** → 内容から適切なタグを推定して新規作成（例: `#data-factory`）

## 完了メッセージ

```
📥 インボックスに追記しました: {タグ}
```
