# 議事録変換ルール

> このファイルは議事録変換の詳細ルールを記載しています。

## 処理フロー

```mermaid
graph TD
    A[ユーザー入力] --> B{日付指定あり?}
    B -->|あり| C[指定日付を使用]
    B -->|なし| D[今日の日付を取得]
    C --> E{フォルダ存在?}
    D --> E
    E -->|なし| F[フォルダ作成 + テンプレート配置]
    E -->|あり| G[既存フォルダを使用]
    F --> G
    G --> H[Teams AI議事録をパース]
    H --> I[テンプレート形式に変換]
    I --> J[議事録ファイル保存]
```

## 検出パターン

以下を検出したらTeams AI議事録と判定:

- 「AI によって生成されます」で始まる
- 「会議のメモ:」を含む
- 「フォローアップ タスク:」を含む

## 変換ルール

| Teams AI形式               | テンプレート                 |
| -------------------------- | ---------------------------- |
| 会議のメモ: [トピック]     | 📝 議事内容 → トピックN      |
| トピック詳細（インデント） | ディスカッション             |
| フォローアップ タスク      | 🚀 今回の持ち帰り事項（NEW） |
| 担当者が自社名             | 自社 持ち帰り                |
| 担当者がお客様名           | お客様 持ち帰り              |

## ファイル確認と連携判定

1. 現在開いているファイルを確認（`editorContext`）
2. ファイル名から日付を抽出（例: `20260204_議事録.md` → `20260204`）
3. 入力データの日付と比較:
   - **一致**: 通常の変換処理
   - **不一致（入力が過去）**: 前回持ち帰りを次回に反映と判断
     - ユーザーに確認してから処理

## フォルダ作成

日付フォルダがなければ作成:

```
{日付}/
├── {日付}_議事録.md       ← _templates/meeting-minutes.md
└── {日付}_内部メモ.md     ← _templates/internal-memo.md
```
