# Localize Instructions

Rules for localizing English PPTX to Japanese.

> ✅ **Purpose**: Optimize English presentations for Japanese-speaking audiences

---

## Translation Scope

| Target          | Include | Notes                                    |
| --------------- | ------- | ---------------------------------------- |
| Slide titles    | ✅      | Keep concise                             |
| Bullet points   | ✅      | Natural Japanese expressions             |
| Speaker notes   | ✅      | Include specific explanations            |
| Product names   | ❌      | Keep in English (Microsoft, Azure, etc.) |
| Technical terms | △       | Use industry-standard translations       |
| Image alt text  | ✅      | If present                               |

---

## Translation Rules

### 1. Product Names (Keep in English)

Keep these in English:

- Microsoft, Azure, Copilot, GitHub
- SharePoint, Teams, OneDrive, Outlook
- Purview, Sentinel, Defender, Fabric
- Windows, Office, Power Platform

### 2. Technical Terms

Use standard Japanese translations:

| English          | Japanese           |
| ---------------- | ------------------ |
| Data security    | データセキュリティ |
| Compliance       | コンプライアンス   |
| Machine learning | 機械学習           |
| Cloud            | クラウド           |
| On-premises      | オンプレミス       |

### 3. Bullet Point Style

- Keep sentences short and impactful
- End with verb forms (〜する、〜できる)
- Avoid passive voice when possible
- Maximum 40 characters per item

### 4. Speaker Notes

**Required content:**

- Explanation of the slide's key message
- Background context
- Speaking hints

**Not acceptable:**

- Only citation: `[Source: Slide #5]`
- Empty notes

---

## Quality Checklist

- [ ] All visible text translated
- [ ] Product names in English
- [ ] Natural Japanese expressions
- [ ] No machine translation artifacts
- [ ] Speaker notes enriched
- [ ] Citations preserved with explanations

---

## Common Mistakes

| Mistake                        | Correct           |
| ------------------------------ | ----------------- |
| マイクロソフト                 | Microsoft         |
| アズール                       | Azure             |
| 彼/彼女 (pronoun ambiguity)    | Reword to avoid   |
| 〜されます (excessive passive) | 〜します (active) |
