# Purpose: Lightning Talk (LT) Instructions

Slide creation guide for lightning talks (5-10 minutes).

---

## Key Constraints

| Constraint      | Target       | Reason                 |
| --------------- | ------------ | ---------------------- |
| Duration        | 5-10 minutes | LT format              |
| Slide count     | 5-12 slides  | ~1 slide per 30-60 sec |
| Words per slide | 10-20 max    | Audience reads quickly |
| Main message    | 1 only       | Focus is key           |

---

## Recommended Structure

### 5-minute LT (5-8 slides)

| #   | Type         | Content                | Time   |
| --- | ------------ | ---------------------- | ------ |
| 1   | Title        | Catchy title + speaker | 15 sec |
| 2   | Problem      | Pain point / Why care? | 45 sec |
| 3   | Solution     | The answer             | 60 sec |
| 4   | Demo/Example | Show don't tell        | 90 sec |
| 5   | Summary      | Key takeaway           | 30 sec |
| 6   | Closing      | CTA + Thank you        | 20 sec |

### 10-minute LT (8-12 slides)

Add:

- More examples (2-3 slides)
- Comparison slide
- Q&A slide

---

## Design Principles

### 🎯 Less is More

- **Big fonts**: Title 44pt+, Body 28pt+
- **Minimal text**: Max 3 bullet points
- **Strong visuals**: 1 image > 10 words
- **High contrast**: Dark background OK for LT

### 🚀 High Impact

- **Bold opening**: Hook in 10 seconds
- **One message**: Repeat it
- **Strong close**: Clear CTA

---

## What to Avoid

| Avoid            | Instead             |
| ---------------- | ------------------- |
| Long paragraphs  | 3-5 word bullets    |
| Complex diagrams | Simple icons        |
| Multiple topics  | One focused message |
| "Thank you" only | CTA + Thank you     |
| Reading slides   | Speak naturally     |

---

## Speaker Notes for LT

Keep notes minimal:

- Timing cues: "(30 sec)"
- Key points to hit
- Transition phrases
- Joke/anecdote reminders

---

## Example Title Slides

**Good:**

```
🚀 Ship Code 10x Faster
with GitHub Copilot

@yourhandle
```

**Avoid:**

```
An Introduction to Improving Developer
Productivity Using AI-Powered Code
Completion Tools in Modern IDEs
```

---

## Timing Tips

- Practice with timer
- Mark 2-minute warning point
- Prepare 1 slide to skip if running late
- End early rather than rushing
