# Purpose: Report / Proposal Instructions

Content creation rules for reports, proposals, and explanatory presentations.

> 📊 **Target**: Internal reports, proposals, explanatory materials, progress reports, results presentations

---

## Slide Structure

| Position | Type              | Purpose                      | Required    |
| -------- | ----------------- | ---------------------------- | ----------- |
| 1        | Title             | Topic, presenter, date       | ✅          |
| 2        | Agenda            | Overview of sections         | ✅          |
| 3        | Executive Summary | Key findings/recommendations | Recommended |
| 4-N      | Content           | Detailed sections            | ✅          |
| N-1      | Summary           | Conclusions, recommendations | ✅          |
| N        | Closing           | Next steps, Q&A              | ✅          |

---

## Content Guidelines

### Executive Summary

- 3-5 key points
- Actionable insights
- Numbers/metrics if available
- Decision/recommendation if applicable

### Body Sections

Each section should have:

- Clear section header (type: "section")
- 2-5 content slides
- Supporting data/visuals
- Section mini-summary if complex

---

## Data Presentation

### Charts and Graphs

| Data Type        | Recommended Chart          |
| ---------------- | -------------------------- |
| Trends over time | Line chart                 |
| Comparisons      | Bar chart                  |
| Proportions      | Pie chart (max 5 segments) |
| Correlations     | Scatter plot               |
| Progress         | Progress bar / gauge       |

### Tables

- Max 5 columns, 7 rows per slide
- Highlight key cells
- Include source/date

---

## Tone Guidelines

### Formal Reports

- Professional language
- Third person preferred
- Data-driven statements
- Clear recommendations

### Progress Reports

- Status indicators (✅ 🟡 ❌)
- Metrics with targets
- Blockers highlighted
- Action items clear

### Proposals

- Problem → Solution structure
- Benefits quantified
- Risks addressed
- Clear ask/CTA

---

## Speaker Notes

For reports and proposals:

1. **Background**: Context not on slide
2. **Data sources**: Where numbers come from
3. **Anticipated questions**: Pre-prepared answers
4. **Discussion points**: What to emphasize

---

## Visual Guidelines

| Element      | Guideline                    |
| ------------ | ---------------------------- |
| Company logo | Title and closing only       |
| Charts       | Consistent colors throughout |
| Icons        | Simple, professional         |
| Photos       | High quality, relevant       |

---

## Quality Checklist

- [ ] Executive summary captures essence
- [ ] Data has sources cited
- [ ] Recommendations are actionable
- [ ] Next steps are specific
- [ ] Timeline included if applicable
- [ ] Owner/contact info clear
