# Aspose.Slides Namespace Guide

## Core

### BuildVersionInfo
Contains information about version of Aspose.Slides.

### BrowsedAtKiosk
Browsed at a kiosk (full screen)

### BrowsedByIndividual
Browsed by individual (window)

### Captions
Represents the WebVTT closed captions.

### CaptionsCollection
Represents a collection of the closed captions.

### DomObject`1
Base DOM object

### DrawingGuide
Represents an adjustable drawing guide.

### HeadingPair
Represents a 'Heading pair' property of the document. It indicates the group name of document parts and the number of parts in group.

### LayoutPlaceholderManager
Represents manager that allows you to add placeholders to the layout slide.

### SlideShowType
Base slide show settings. Ancestors represent types of the slide show:

---

## Charts

### ChartDataPointLevel
Represents data point level. Applies for Treemap and Sunburst chart.

### ChartDataPointLevelsManager
Container of data point levels. Applied for Treeamp and Sunburst series. Data point levels indexing is zero-based.

### ChartDataCell
Represents cell for chart data.

### ChartDataWorkbook
Provides access to embedded Excel workbook

### ChartDataWorksheet
Represents worksheet associated with

### DataLabelFormat
Represents formatting options for DataLabel.

### Format
Represents chart format properties.

### NamespaceDoc
Contains classes for work with charts in Microsoft PowerPoint presentations.

### PieSplitCustomPointCollection
Represents a collection of points for splitting point in a bar-of-pie or pie-of-pie chart with a custom split.

### ChartPortionFormat
This class contains the chart portion formatting properties used in charts. Unlike

---

## Animation

### BehaviorProperty
Represent property types for animation behavior. Follows the list of properties from https://msdn.microsoft.com/en-us/library/dd949052(v=office.15).aspx and https://msdn.microsoft.com/en-us/library/documentformat.openxml.presentation.attributename(v=office.15).aspx

### BehaviorPropertyCollection
Represents timing properties for the effect behavior.

### NamespaceDoc
Contains classes for work with animation in Microsoft PowerPoint presentations.

### AnimationTimeLine
Represents timeline of animation.

### Behavior
Represent base class behavior of effect.

### BehaviorCollection
Represents collection of behavior effects.

### ColorEffect
Represents a color effect for an animation behavior.

### ColorOffset
Represent color offset.

### CommandEffect
Represents a command effect for an animation behavior.

### Effect
Represents animation effect.

---

## Export

### FrameTickEventArgs
Represents arguments of the

### IPresentationAnimationPlayer
Represents a player of the animation.

### PresentationAnimationsGenerator
Represents a generator of the animations in the

### PresentationPlayer
Represents the player of animations associated with the

### HandoutLayoutingOptions
Represents the handout presentation layout mode for export.

### InkOptions
Provides options that control the look of Ink objects in exported document.

### HandleRepeatedSpaces
Specifies how repeated regular space characters should be handled during Markdown export.

### MarkdownExportType
Type of rendering document.

### Flavor
All markdown specifications used in program.

### MarkdownSaveOptions
Represents options that control how presentation should be saved to markdown.

---

