---
name: ai-proofreading
description: 系统化降低AI检测率至30%以下，通过三遍审校流程（内容、风格、细节）增加人味。当用户提到"AI味太重"、"像AI写的"、"降低AI检测率"、"更像人写的"、"自然一些"、"口语化"时使用此技能。
---

# AI味审校

## 何时使用此Skill
当用户出现以下任一需求时，使用此技能：
- 提到内容"AI味太重"、"像AI写的"、"太机械"
- 要求"降低AI检测率"、"更像人写的"、"自然一些"
- 需要"口语化"、"有温度"、"接地气"的表达
- 内容被AI检测工具标记为高AI概率
- 希望文章更具个性和真实感

## 核心目标
通过系统化的三遍审校流程，将内容的AI检测率从80-100%降低至30%以下，让文章更具人味和真实性。

## 执行流程

### 第一遍：内容结构调整 (P0级检查)
**目标**：修复明显的AI结构特征

**检查要点**：
1. **避免教科书式结构**
   - ❌ "首先...其次...最后..."的机械结构
   - ✅ 使用自然的转折和过渡

2. **避免定义式开头**
   - ❌ "什么是XX？XX是指..."
   - ✅ 直接切入主题或使用引子开头

3. **避免总结式结尾**
   - ❌ "综上所述，总而言之..."
   - ✅ 自然收尾或留有余韵

4. **增加个人化表达**
   - 插入个人观点、经历、感受
   - 使用"我觉得"、"在我看来"等表达

### 第二遍：语言风格优化 (P1级检查)
**目标**：让语言更自然、更有温度

**检查要点**：
1. **替换书面化词汇**
   - ❌ "进行"、"实现"、"提供"
   - ✅ "做"、"完成"、"给"

2. **增加口语化表达**
   - ❌ "该产品具备..."、"此方法..."
   - ✅ "这个产品能..."、"这个方法..."

3. **使用生活化比喻**
   - 结合日常生活经验打比方
   - 避免过于专业的抽象表达

4. **调整句式节奏**
   - 长短句结合，避免全是长句
   - 适当使用设问、感叹等句式

### 第三遍：细节润色 (P2级检查)
**目标**：增加真实感和可信度

**检查要点**：
1. **增加具体细节**
   - 补充时间、地点、人物等具体信息
   - 使用数字、百分比等量化表达

2. **添加情绪色彩**
   - 适当表达惊讶、失望、兴奋等情绪
   - 使用感叹词、语气词增加感染力

3. **优化连接词**
   - 减少"因此"、"然而"、"另外"等正式连接词
   - 使用"不过"、"而且"、"对了"等口语连接

4. **检查逻辑合理性**
   - 确保论证过程自然流畅
   - 避免过于完美的逻辑闭环

## 质量标准
- AI检测率 < 30%
- 保持原意不变
- 增加至少3个个人化表达
- 语言风格与目标读者匹配

---
*最后更新：2024年*