---
name: image-generation
description: 自动为文章生成配图，支持AI生成图片、公共领域图片、免费图库图片，并上传到ImgBB图床生成Markdown链接。当用户提到"配图"、"插图"、"图片"、"生成图片"、"文章配图"时使用此技能。
---

# 图片配图与上传

## 何时使用此Skill
当用户出现以下任一需求时，使用此技能：
- 要求给文章"配图"、"加插图"、"生成图片"
- 需要"文章配图"、"内容配图"、"封面图"
- 提到"找图片"、"要个图"、"来张图"
- 希望文章"更生动"、"有图有真相"

## 核心目标
为文章快速生成合适的配图，并自动上传到图床，直接生成可用的Markdown图片链接，让用户无需手动处理图片。

## 执行流程

### 第一步：理解图片需求
**目标**：确定图片的主题、风格和用途

**分析要点**：
1. **文章主题理解**
   - 提取文章的核心概念和关键词
   - 确定配图要表达的主要信息
   - 分析目标读者的审美偏好

2. **图片用途判断**
   - 文章主图/封面图
   - 章节分隔图
   - 概念示意图
   - 装饰性插图

3. **风格偏好确认**
   - 专业商务风 vs 轻松生活风
   - 现代简约风 vs 复古怀旧风
   - 手绘插画风 vs 真实照片风

### 第二步：选择图片来源
**目标**：根据需求选择最合适的图片来源

**选择优先级**：
1. **公共领域图片** (首选)
   - 来源：Unsplash, Pexels, Pixabay
   - 优势：免费、高质量、商用友好
   - 适用：通用主题、风景、人物、场景

2. **AI生成图片** (次选)
   - 工具：DALL-E, Midjourney, Stable Diffusion
   - 优势：完全定制、无版权问题
   - 适用：抽象概念、特定场景、创意表达

3. **免费图库图片** (备选)
   - 来源：Freepik, Canva免费资源
   - 优势：设计感强、风格统一
   - 适用：商业主题、信息图表

### 第三步：生成或搜索图片
**目标**：获取高质量的图片文件

**操作步骤**：
1. **关键词优化**
   - 生成3-5个不同的搜索关键词
   - 包含英文和中文关键词
   - 添加风格修饰词（如：minimalist, professional）

2. **图片筛选标准**
   - 分辨率：最低1920x1080
   - 构图：主体突出，画面简洁
   - 色彩：与文章风格协调
   - 内容：无明显水印，画面清晰

3. **批量获取**
   - 一次获取3-5张候选图片
   - 让用户有选择余地

### 第四步：上传到图床
**目标**：将图片上传到可靠的图床服务

**使用 ImgBB 图床**：
1. **上传准备**
   - 图片重命名为描述性名称
   - 检查文件大小（建议<5MB）
   - 确认图片格式（JPG/PNG）

2. **上传操作**
   - 使用 ImgBB API 或网页上传
   - 设置适当的标题和描述
   - 选择公开访问权限

3. **链接处理**
   - 获取直链URL
   - 备份多个链接以防失效
   - 记录上传时间和信息

### 第五步：生成Markdown内容
**目标**：为用户提供可直接使用的Markdown代码

**输出格式**：
```markdown
![图片描述](图片链接)
```

**附加信息**：
- 图片尺寸建议
- 替代文本优化建议
- 版权信息（如适用）

## 特殊处理场景

### 1. 概念类文章
**配图策略**：
- 使用抽象图形或隐喻图片
- 选择简洁的几何图形
- 避免具体人物或场景

### 2. 教程类文章
**配图策略**：
- 使用步骤示意图
- 选择相关的工具或场景
- 保持图片的专业性

### 3. 观点类文章
**配图策略**：
- 使用思考或讨论场景
- 选择表达情感的人物图片
- 增加图片的情感共鸣

## 质量标准
- 图片清晰度 >= 1920x1080
- 图床链接稳定可靠
- Markdown格式正确
- 图片内容与文章主题相关度 > 80%

## 注意事项
- 确保图片版权合规
- 避免使用有争议的内容
- 考虑不同设备的显示效果
- 为图片添加合适的alt文本

---
*最后更新：2024年*