---
name: info-search-knowledge
description: 针对新产品、新技术进行多渠道信息搜索和验证，并将可靠信息保存到知识库。优先选择权威科技媒体，忽略过时信息源。当用户提到"最新信息"、"新产品"、"新技术"、"搜索资料"、"查资料"、"了解XX"时使用此技能。
---

# 信息搜索与知识管理

## 何时使用此Skill
当用户出现以下任一需求时，使用此技能：
- 需要了解"最新信息"、"新动态"
- 研究特定"新产品"、"新技术"
- 需要"搜索资料"、"查资料"、"调研"
- 希望深入了解某个领域或产品
- 需要获取权威、可靠的信息源

## 核心目标
通过系统化的多渠道搜索和信息验证，为用户提供准确、权威、最新的信息，并将有价值的信息保存到知识库中，方便后续查阅和使用。

## 执行流程

### 第一步：信息需求分析
**目标**：明确搜索目标和信息质量要求

**需求分析维度**：
1. **信息类型确认**
   - 新产品信息：功能、价格、发布时间、用户评价
   - 技术信息：技术原理、应用场景、发展趋势
   - 行业动态：市场趋势、竞争格局、政策变化
   - 学术信息：研究进展、理论发展、实践应用

2. **时效性要求**
   - 最新信息：最近3个月内
   - 重要信息：最近6个月内
   - 背景信息：1年内的相关发展
   - 历史信息：行业发展的关键节点

3. **权威性要求**
   - 权威媒体：行业知名媒体、官方发布
   - 专家观点：行业专家、学者观点
   - 用户反馈：真实用户体验、评价
   - 数据支撑：统计数据、市场报告

4. **搜索范围界定**
   - 地理范围：国内市场、国际市场
   - 语言范围：中文信息、英文信息
   - 深度要求：概览信息、深度分析
   - 角度多元：技术、商业、用户、监管等角度

### 第二步：权威信息源选择
**目标**：确定可靠的信息搜索渠道

**优先级信息源**：

#### P0级信息源（最高优先级）
1. **官方发布渠道**
   - 公司官网、官方博客
   - 官方社交媒体账号
   - 财报、投资者关系页面
   - API文档、技术文档

2. **权威科技媒体**
   - 国内：36氪、虎嗅、钛媒体、InfoQ
   - 国际：TechCrunch、The Verge、Wired、Ars Technica
   - 垂直：特定行业的专业媒体

#### P1级信息源（高优先级）
1. **行业报告和研究**
   - 咨询公司报告：麦肯锡、BCG、IDC、Gartner
   - 市场研究：艾瑞、易观、QuestMobile
   - 学术论文：arXiv、IEEE、ACM

2. **专业社区和论坛**
   - GitHub、Stack Overflow、Reddit
   - V2EX、掘金、CSDN
   - 专业微信群、知识星球

#### P2级信息源（参考优先级）
1. **自媒体和博主**
   - 行业知名博主、UP主
   - 专业领域的意见领袖
   - 经验丰富的从业者

2. **用户评价和反馈**
   - 应用商店评价
   - 社交媒体讨论
   - 产品测评文章

### 第三步：多渠道搜索执行
**目标**：系统化收集各类信息

**搜索策略**：
1. **关键词组合搜索**
   ```
   基础关键词：[产品/技术名称]
   组合1：+ [发布时间] + [功能特性]
   组合2：+ [评测] + [用户体验]
   组合3：+ [竞品对比] + [市场分析]
   组合4：+ [问题] + [解决方案]
   ```

2. **时间筛选搜索**
   - 最近1个月：最新动态、用户反馈
   - 最近3个月：产品更新、市场反应
   - 最近6个月：发展趋势、竞争变化
   - 最近1年：行业发展、技术演进

3. **多语言搜索**
   - 中文搜索：了解国内市场和用户反馈
   - 英文搜索：获取国际视角和深度分析
   - 本地化搜索：特定地区的信息

4. **交叉验证搜索**
   - 同一信息在不同来源的验证
   - 官方信息与第三方信息的对比
   - 正面评价与负面评价的平衡

### 第四步：信息质量验证
**目标**：确保信息的准确性和可靠性

**验证标准**：
1. **来源可信度评估**
   - 发布机构的专业性和权威性
   - 作者的专业背景和资质
   - 发布平台的声誉和影响力

2. **内容真实性检查**
   - 事实陈述的可验证性
   - 数据来源的可靠性
   - 逻辑推理的合理性

3. **时效性判断**
   - 信息发布的时间
   - 信息的更新频率
   - 行业变化的速度

4. **客观性评估**
   - 是否存在明显的偏见
   - 利益相关性的披露
   - 多角度观点的平衡

### 第五步：知识库保存和管理
**目标**：将高质量信息结构化保存

**知识库结构**：
```
knowledge-base/
├── products/                    # 产品信息
│   ├── [产品名称]/
│   │   ├── basic-info.md        # 基本信息
│   │   ├── features.md          # 功能特性
│   │   ├── market-analysis.md   # 市场分析
│   │   ├── user-reviews.md      # 用户评价
│   │   └── competitor-analysis.md # 竞品分析
├── technologies/                # 技术信息
│   ├── [技术名称]/
│   │   ├── overview.md          # 技术概述
│   │   ├── principles.md        # 技术原理
│   │   ├── applications.md      # 应用场景
│   │   ├── trends.md            # 发展趋势
│   │   └── resources.md         # 学习资源
└── industries/                  # 行业信息
    ├── [行业名称]/
    │   ├── overview.md          # 行业概述
    │   ├── market-size.md       # 市场规模
    │   ├── key-players.md       # 主要玩家
    │   ├── trends.md            # 发展趋势
    │   └── regulations.md       # 政策法规
```

**信息保存格式**：
```markdown
# [信息标题]

## 基本信息
- **名称**：[产品/技术名称]
- **类型**：[分类]
- **发布时间**：[YYYY-MM-DD]
- **最新更新**：[YYYY-MM-DD]

## 核心要点
[3-5个最重要的信息点]

## 详细信息
[详细的内容描述]

## 信息来源
1. [来源1] - [链接] - [获取时间]
2. [来源2] - [链接] - [获取时间]

## 相关信息
- [相关产品/技术]
- [竞品信息]
- [行业背景]

## 可信度评级
⭐⭐⭐⭐⭐ [评级说明]

## 备注
[额外的说明或注意事项]
```

### 第六步：信息整合和输出
**目标**：为用户提供结构化的信息报告

**报告结构**：
```
# [搜索主题] - 信息报告

## 📊 信息概览
- **搜索时间**：[YYYY-MM-DD HH:MM:SS]
- **信息来源**：[数量]个权威来源
- **信息时效性**：最新[天数]内
- **可信度评级**：⭐⭐⭐⭐⭐

## 🔍 核心发现
1. [最重要的发现1]
2. [最重要的发现2]
3. [最重要的发现3]

## 📈 详细信息

### 基本信息
[基础信息整理]

### 功能特性
[功能和技术特性]

### 市场表现
[市场数据和分析]

### 用户反馈
[用户评价和反馈]

### 竞争分析
[竞争格局分析]

## 🎯 关键洞察
[基于信息的分析和洞察]

## 📚 延伸阅读
[推荐的相关信息和资源]

## ⚠️ 注意事项
[需要注意的限制或风险]
```

## 特殊处理场景

### 1. 新兴技术搜索
**策略**：
- 优先查找学术论文和技术白皮书
- 关注技术社区的讨论和实践
- 查找早期采用者的使用经验
- 注意信息的时效性和不确定性

### 2. 敏感信息搜索
**策略**：
- 优先使用官方权威信息
- 避免传播未经证实的信息
- 标注信息的可信度和风险
- 建议进一步验证

### 3. 多角度信息搜索
**策略**：
- 从技术、商业、用户、监管等角度搜索
- 平衡正面和负面信息
- 提供多元观点和判断
- 帮助用户形成全面认知

## 质量标准

### 信息质量标准
- [ ] 来源权威可信
- [ ] 内容准确可靠
- [ ] 信息及时有效
- [ ] 观点客观平衡

### 服务质量标准
- [ ] 搜索范围全面
- [ ] 信息整理规范
- [ ] 知识库保存完整
- [ ] 报告结构清晰

## 使用建议

### 搜索技巧
- 使用具体的关键词组合
- 注意时间筛选和来源筛选
- 多渠道交叉验证信息
- 关注信息的更新频率

### 知识库维护
- 定期更新过时信息
- 清理无效链接和资源
- 增加新的有价值信息
- 保持分类体系的清晰

---
*最后更新：2024年*