---
name: topic-generation
description: 快速生成3-4个文章选题方向，包含标题建议、内容大纲、工作量评估、目标受众分析和优劣势分析。当用户提到"选题"、"写什么"、"内容选题"、"文章方向"、"创作灵感"时使用此技能。
---

# 选题生成

## 何时使用此Skill
当用户出现以下任一需求时，使用此技能：
- 需要文章"选题"、"选题方向"
- 不知道"写什么"、"创作什么"
- 缺少"内容灵感"、"创作思路"
- 需要"文章方向"、"内容规划"
- 希望获得"选题建议"、"主题推荐"

## 核心目标
根据用户需求快速生成多个高质量的选题方案，每个方案都包含完整的执行计划，帮助用户快速确定创作方向并开始内容创作。

## 执行流程

### 第一步：需求分析和背景了解
**目标**：充分理解用户的创作需求和背景

**关键信息收集**：
1. **创作类型确认**
   - 文章类型：博客文章、社交媒体、教程、观点文
   - 内容领域：技术、生活、职场、教育、娱乐
   - 目标长度：短文(500-1000字)、中等(1000-3000字)、长文(3000+字)

2. **目标受众分析**
   - 读者群体：年龄、职业、兴趣、知识水平
   - 阅读场景：工作时间、休闲时间、学习时间
   - 期望收获：知识获取、技能提升、娱乐放松

3. **创作目标设定**
   - 主要目的：品牌建设、知识分享、商业转化
   - 成功指标：阅读量、互动率、转化率
   - 时间要求：紧急(1-2天)、正常(1周)、从容(2周+)

4. **资源约束评估**
   - 可用时间：调研时间、写作时间、修改时间
   - 专业背景：领域熟悉程度、研究深度要求
   - 技术工具：是否需要特殊工具或资源

### 第二步：多方向选题生成
**目标**：生成3-4个不同角度的选题方案

**选题策略**：
1. **热点结合型选题**
   - 结合当前热点话题和趋势
   - 提供独特视角和深度分析
   - 容易获得流量和关注

2. **问题解决型选题**
   - 针对目标受众的痛点问题
   - 提供实用的解决方案
   - 具有长期价值和复用性

3. **经验分享型选题**
   - 分享个人经历和心得
   - 真实性强，容易产生共鸣
   - 建立个人品牌和专业形象

4. **趋势预测型选题**
   - 分析行业发展趋势
   - 提供前瞻性见解
   - 展现专业洞察力

### 第三步：选题方案详细设计
**目标**：为每个选题提供完整的执行方案

**方案结构**：

#### 选项1：[选题标题]
**选题类型**：[热点/问题解决/经验分享/趋势预测]

**核心亮点**：
- 🎯 主要卖点：[1-2个核心吸引力]
- 💡 创新点：[独特视角或方法]
- 📈 预期效果：[流量、互动、转化预期]

**内容大纲**：
```
一、开头钩子
   [如何吸引读者注意力的开头]

二、主体部分
   1. [主要论点1]
   2. [主要论点2]
   3. [主要论点3]

三、实用价值
   [读者能获得的具体价值]

四、结尾总结
   [如何让读者有收获感的结尾]
```

**工作量评估**：
- 调研时间：[X小时/天]
- 写作时间：[X小时/天]
- 修改时间：[X小时/天]
- 总工作量：[总计时间]

**目标受众**：
- 主要受众：[具体人群描述]
- 次要受众：[潜在受众描述]
- 读者规模：[预估覆盖人群]

**优势分析**：
- ✅ [优势1：如流量潜力大]
- ✅ [优势2：如实用性强]
- ✅ [优势3：如容易传播]

**挑战分析**：
- ⚠️ [挑战1：如竞争激烈]
- ⚠️ [挑战2：如需要深度研究]
- ⚠️ [挑战3：如时效性要求高]

**成功概率**：[高/中/低] - [原因说明]

### 第四步：综合对比和推荐
**目标**：帮助用户做出最终选择

**对比维度**：
1. **执行难度**：时间投入、专业要求、资源需求
2. **预期效果**：流量潜力、用户价值、商业价值
3. **风险评估**：竞争风险、时效风险、质量风险
4. **个人匹配**：专业匹配、兴趣匹配、资源匹配

**推荐逻辑**：
```
如果你希望 [目标1]，推荐选择 [选项X]
如果你更关注 [目标2]，推荐选择 [选项Y]
如果你的限制条件是 [限制条件]，推荐选择 [选项Z]
```

## 特殊场景处理

### 1. 创作瓶颈期
**策略**：
- 提供跨领域的选题建议
- 建议从不同角度思考
- 推荐合作或采访形式

### 2. 资源有限情况
**策略**：
- 优先推荐经验分享型选题
- 建议利用现有知识和经验
- 提供轻量级的创作方案

### 3. 商业导向需求
**策略**：
- 重点关注转化率选题
- 结合产品或服务特点
- 提供明确的商业价值路径

## 质量标准

### 选题质量标准
- [ ] 符合用户目标和受众需求
- [ ] 具有独特性和差异化
- [ ] 在能力范围内可执行
- [ ] 有明确的价值主张

### 方案完整性标准
- [ ] 包含完整的执行计划
- [ ] 提供准确的工作量评估
- [ ] 分析清楚优劣势
- [ ] 给出明确的推荐理由

## 交付示例

### 示例：Python编程教程选题

**需求背景**：用户是Python开发者，想写技术博客提升个人品牌

**生成方案**：

#### 选项1：Python性能优化10个技巧
**选题类型**：问题解决型

**核心亮点**：
- 🎯 实用性强，直接解决开发痛点
- 💡 汇总个人实战经验，有独特见解
- 📈 容易被收藏和转发

**工作量评估**：
- 调研时间：2小时（验证技巧有效性）
- 写作时间：4小时（含代码示例）
- 修改时间：2小时
- 总工作量：8小时

**成功概率**：高 - 内容实用，受众明确

#### 选项2：Python在AI领域的5个创新应用
**选题类型**：趋势预测型

**核心亮点**：
- 🎯 结合AI热点，流量潜力大
- 💡 前瞻性内容，展现专业视野
- 📈 容易建立权威形象

**工作量评估**：
- 调研时间：6小时（需要研究最新案例）
- 写作时间：5小时
- 修改时间：3小时
- 总工作量：14小时

**成功概率**：中 - 竞争激烈，需要独特视角

**推荐**：如果时间有限，推荐选项1；如果要建立权威形象，推荐选项2

---
*最后更新：2024年*