---
name: video-thumbnail-check
description: 基于MrBeast策略检查视频标题、缩略图和内容钩子，优化点击率和观看时长。当用户提到"视频标题"、"封面图"、"缩略图"、"点击率"、"CTR"、"观看时长"、"视频开头"时使用此技能。
---

# 视频封标与承接检查

## 何时使用此Skill
当用户出现以下任一需求时，使用此技能：
- 检查"视频标题"、"封面图"、"缩略图"
- 优化"点击率"、"CTR"、"观看时长"
- 改进"视频开头"、"内容钩子"
- 提升视频"吸引眼球"、"让人想点"
- 应用"MrBeast策略"、"爆款视频"技巧

## 核心目标
通过系统化的标题、缩略图和开头检查，显著提升视频的点击率（目标提升20-40%）和观看时长，让视频更具吸引力。

## 执行流程

### 第一步：标题检查 (P0级优化)
**目标**：确保标题具备强烈的点击吸引力

**检查维度**：
1. **好奇心驱动检查**
   - ✅ 是否制造悬念或未解之谜
   - ✅ 是否暗示有意外结果
   - ✅ 是否让用户产生"想知道答案"的冲动

2. **价值承诺检查**
   - ✅ 是否明确承诺用户能获得什么
   - ✅ 是否暗示有独特或稀缺的信息
   - ✅ 是否使用具体的数字和结果

3. **情绪共鸣检查**
   - ✅ 是否触动用户的某种情绪
   - ✅ 是否使用了强烈的形容词
   - ✅ 是否让用户产生共鸣

**标题优化策略**：
```
❌ 普通标题：如何制作美食
✅ 优化标题：3个让米其林厨师都惊艳的家常菜做法

❌ 普通标题：我的创业故事
✅ 优化标题：从负债50万到年入千万，我只做对了这一件事
```

### 第二步：缩略图检查 (P1级优化)
**目标**：确保缩略图能够在信息流中脱颖而出

**检查要点**：
1. **视觉冲击力**
   - ✅ 是否有强烈对比（色彩、明暗、大小）
   - ✅ 是否有清晰的主要视觉焦点
   - ✅ 是否在缩小后依然清晰可辨

2. **情绪表达**
   - ✅ 人物表情是否夸张或有趣
   - ✅ 是否能瞬间传达情绪
   - ✅ 是否让用户产生情感连接

3. **信息传达**
   - ✅ 是否与标题形成呼应
   - ✅ 是否暗示视频的核心内容
   - ✅ 文字是否简洁有力

**缩略图设计原则**：
- **人脸优先**：有表情的人脸比无生命物体更吸引点击
- **高对比度**：使用强烈的色彩对比
- **简洁文字**：最多6-8个字，字体粗大醒目
- **留白空间**：避免画面过于拥挤

### 第三步：内容钩子检查 (P2级优化)
**目标**：确保视频开头3-10秒能够抓住观众注意力

**钩子类型检查**：
1. **结果前置型钩子**
   - ✅ 是否先展示最终结果
   - ✅ 是否立即显示最精彩的画面
   - ✅ 是否让用户产生"想知道过程"的欲望

2. **疑问悬念型钩子**
   - ✅ 是否提出引人入胜的问题
   - ✅ 是否暗示有意外的发展
   - ✅ 是否制造了信息缺口

3. **情绪冲击型钩子**
   - ✅ 是否展示了强烈的情绪反应
   - ✅ 是否使用了戏剧化的表现手法
   - ✅ 是否让用户产生情感共鸣

### 第四步：一致性检查 (关键验证)
**目标**：确保标题、缩略图、内容三者高度一致

**一致性验证**：
1. **承诺兑现检查**
   - ✅ 视频内容是否兑现了标题的承诺
   - ✅ 缩略图是否真实反映了视频内容
   - ✅ 是否避免了标题党和误导

2. **期望管理检查**
   - ✅ 用户期望是否得到合理满足
   - ✅ 是否有超出预期的惊喜
   - ✅ 整体体验是否令人满意

## 5种对比公式应用

### 1. 前后对比公式
**结构**：之前的状态 → 之后的结果
**应用**：减肥、装修、技能学习等
**示例**："从月薪3000到月薪3万，我是如何做到的"

### 2. 优劣对比公式
**结构**：错误的做法 → 正确的做法
**应用**：教程、测评、经验分享等
**示例**："90%的人都做错了，正确的做法竟然这么简单"

### 3. 数量对比公式
**结构**：小数字 → 大数字
**应用**：收入、粉丝、成就等
**示例**："1个方法让我多赚了100万"

### 4. 时间对比公式
**结构**：长时间 → 短时间
**应用**：效率提升、快速达成等
**示例**："原本需要3小时，现在只要10分钟"

### 5. 难度对比公式
**结构**：高难度 → 低难度
**应用**：技能教学、问题解决等
**示例**："这个看起来很难，其实人人都能学会"

## 悬念结构设计

### 悬念递进三层结构
1. **第一层悬念**：引发好奇
2. **第二层悬念**：制造期待
3. **第三层悬念**：强化需求

### 实施示例
```
第一层：我发现了一个秘密...（引发好奇）
第二层：这个秘密改变了我的生活...（制造期待）
第三层：今天我要分享这个能改变你人生的秘密...（强化需求）
```

## 质量标准
- 标题吸引力得分 >= 8/10
- 缩略图视觉冲击力得分 >= 8/10
- 内容钩子留存率提升 >= 20%
- 整体一致性得分 >= 9/10

## 优化检查清单

### 标题检查清单
- [ ] 有制造悬念或好奇心的元素
- [ ] 包含具体的数字或结果
- [ ] 长度控制在60字以内
- [ ] 避免使用过于专业的术语
- [ ] 与视频核心内容高度相关

### 缩略图检查清单
- [ ] 主要视觉元素清晰突出
- [ ] 色彩对比强烈
- [ ] 文字简洁醒目（如有）
- [ ] 在小尺寸下依然可识别
- [ ] 与标题形成互补关系

### 内容钩子检查清单
- [ ] 前3秒抓住注意力
- [ ] 设置了明确的悬念
- [ ] 预告了视频的价值
- [ ] 制造了信息缺口
- [ ] 情感上有冲击力

## 特殊场景处理

### 1. 教育类视频
**优化重点**：
- 强调学习效果和收益
- 使用"简单易懂"等降低门槛词汇
- 突出实用性和可操作性

### 2. 娱乐类视频
**优化重点**：
- 强调趣味性和娱乐性
- 使用夸张的形容词
- 制造强烈的情感共鸣

### 3. 商业类视频
**优化重点**：
- 强调商业价值和收益
- 使用具体的商业数据和案例
- 建立专业性和权威性

---
*最后更新：2024年*